/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.loader;

import android.content.Context;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.FutureTarget;
import com.transsion.lib_web.WebLogger;
import com.transsion.lib_web.zip.loader.WebViewLoader;
import com.transsion.lib_web.zip.utils.MimeTypeMapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J(\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/transsion/lib_web/zip/loader/WebViewGlideLoader;", "Lcom/transsion/lib_web/zip/loader/WebViewLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "clearCache", "", "getCachePath", "Ljava/io/File;", "interceptRequest", "Landroid/webkit/WebResourceResponse;", "request", "Landroid/webkit/WebResourceRequest;", "url", "", "headers", "", "lib_web_release"})
public final class WebViewGlideLoader
implements WebViewLoader {
    @NotNull
    private final Context context;

    public WebViewGlideLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable WebResourceRequest request) {
        WebResourceRequest webResourceRequest = request;
        Map map = webResourceRequest != null ? webResourceRequest.getRequestHeaders() : null;
        WebResourceRequest webResourceRequest2 = request;
        return this.interceptRequest(webResourceRequest2 != null && (webResourceRequest2 = webResourceRequest2.getUrl()) != null ? webResourceRequest2.toString() : null, map == null ? (Map)new HashMap() : map);
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (url == null) {
            return null;
        }
        try {
            String mimeType;
            String string = mimeType = MimeTypeMapUtils.INSTANCE.getMimeTypeFromUrl(url);
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"image/", (boolean)false, (int)2, null) : false;
            if (bl) {
                FutureTarget futureTarget = Glide.with((Context)this.context).asFile().load(url).submit();
                Intrinsics.checkNotNullExpressionValue((Object)futureTarget, (String)"with(context).asFile().load(url).submit()");
                FutureTarget submit = futureTarget;
                InputStream inputStream = new FileInputStream((File)submit.get());
                WebLogger.INSTANCE.logD("WebViewGlideLoader --> interceptRequest() --> glide file   \nurl = " + url + "  \nmimeType = " + mimeType);
                return new WebResourceResponse(mimeType, "", 200, "OK", (Map)WebViewLoader.Companion.getResponseHeaders(), inputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Nullable
    public File getCachePath() {
        return null;
    }

    @Override
    public void clearCache() {
    }
}

