/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.loader;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.blankj.utilcode.util.NetworkUtils;
import com.tn.lib.logger.Logger;
import com.transsion.lib_web.zip.loader.CacheExtensionConfig;
import com.transsion.lib_web.zip.loader.HttpCacheInterceptor;
import com.transsion.lib_web.zip.loader.WebViewLoader;
import com.transsion.lib_web.zip.utils.MimeTypeMapUtils;
import com.transsion.lib_web.zip.utils.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u000eH\u0016J\u0014\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J(\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/transsion/lib_web/zip/loader/WebViewOkhttpLoader;", "Lcom/transsion/lib_web/zip/loader/WebViewLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mCacheExtensionConfig", "Lcom/transsion/lib_web/zip/loader/CacheExtensionConfig;", "getMCacheExtensionConfig", "()Lcom/transsion/lib_web/zip/loader/CacheExtensionConfig;", "setMCacheExtensionConfig", "(Lcom/transsion/lib_web/zip/loader/CacheExtensionConfig;)V", "mCacheFile", "Ljava/io/File;", "mCacheSize", "", "mConnectTimeout", "mHttpClient", "Lokhttp3/OkHttpClient;", "mReadTimeout", "addHeader", "", "reqBuilder", "Lokhttp3/Request$Builder;", "headers", "", "", "checkUrl", "", "url", "clearCache", "getCachePath", "interceptRequest", "Landroid/webkit/WebResourceResponse;", "request", "Landroid/webkit/WebResourceRequest;", "", "lib_web_release"})
@SourceDebugExtension(value={"SMAP\nWebViewOkhttpLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewOkhttpLoader.kt\ncom/transsion/lib_web/zip/loader/WebViewOkhttpLoader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,149:1\n215#2,2:150\n*S KotlinDebug\n*F\n+ 1 WebViewOkhttpLoader.kt\ncom/transsion/lib_web/zip/loader/WebViewOkhttpLoader\n*L\n141#1:150,2\n*E\n"})
public final class WebViewOkhttpLoader
implements WebViewLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final File mCacheFile;
    private final long mCacheSize;
    private final long mConnectTimeout;
    private final long mReadTimeout;
    @NotNull
    private final OkHttpClient mHttpClient;
    @NotNull
    private CacheExtensionConfig mCacheExtensionConfig;

    public WebViewOkhttpLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mCacheFile = new File(this.context.getCacheDir(), "web_okhttp");
        this.mCacheSize = 0x6400000L;
        this.mConnectTimeout = 30L;
        this.mReadTimeout = 30L;
        this.mCacheExtensionConfig = new CacheExtensionConfig();
        this.mCacheExtensionConfig.addExtension("json").removeExtension("swf");
        Cache cache = new Cache(this.mCacheFile, this.mCacheSize);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cache(cache).connectTimeout(this.mConnectTimeout, TimeUnit.SECONDS).readTimeout(this.mReadTimeout, TimeUnit.SECONDS).addNetworkInterceptor((Interceptor)new HttpCacheInterceptor());
        this.mHttpClient = builder.build();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final CacheExtensionConfig getMCacheExtensionConfig() {
        return this.mCacheExtensionConfig;
    }

    public final void setMCacheExtensionConfig(@NotNull CacheExtensionConfig cacheExtensionConfig) {
        Intrinsics.checkNotNullParameter((Object)cacheExtensionConfig, (String)"<set-?>");
        this.mCacheExtensionConfig = cacheExtensionConfig;
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable WebResourceRequest request) {
        WebResourceResponse webResourceResponse;
        WebResourceRequest webResourceRequest = request;
        if (webResourceRequest != null) {
            WebResourceRequest it = webResourceRequest;
            boolean bl = false;
            String string = it.getUrl().toString();
            Map map = it.getRequestHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.requestHeaders");
            webResourceResponse = this.interceptRequest(string, map);
        } else {
            webResourceResponse = null;
        }
        return webResourceResponse;
    }

    @Override
    @Nullable
    public File getCachePath() {
        return null;
    }

    @Override
    public void clearCache() {
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (url == null) {
            return null;
        }
        if (!this.checkUrl(url)) {
            return null;
        }
        try {
            Request request;
            Response response;
            Response cacheRes;
            Request.Builder reqBuilder = new Request.Builder().url(url);
            String extension = MimeTypeMapUtils.INSTANCE.getFileExtensionFromUrl(url);
            if (this.mCacheExtensionConfig.isHtml(extension)) {
                headers.put("WebResourceInterceptor-Key-Cache", "ordinal");
            }
            this.addHeader(reqBuilder, headers);
            if (!NetworkUtils.isConnected()) {
                reqBuilder.cacheControl(CacheControl.FORCE_CACHE);
            }
            if ((cacheRes = (response = this.mHttpClient.newCall(request = reqBuilder.build()).execute()).cacheResponse()) != null) {
                var9_9 = "from cache: %s";
                var10_10 = new Object[]{url};
                String string = String.format(var9_9, Arrays.copyOf(var10_10, var10_10.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                Logger.Companion.d$default((Logger.Companion)Logger.Companion, (String)string, (boolean)false, (int)2, null);
            } else {
                var9_9 = "from server: %s";
                var10_10 = new Object[]{url};
                String string = String.format(var9_9, Arrays.copyOf(var10_10, var10_10.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                Logger.Companion.d$default((Logger.Companion)Logger.Companion, (String)string, (boolean)false, (int)2, null);
            }
            String mimeType = MimeTypeMapUtils.INSTANCE.getMimeTypeFromUrl(url);
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            WebResourceResponse webResourceResponse = new WebResourceResponse(mimeType, "", responseBody.byteStream());
            if (response.code() == 504 && !NetworkUtils.isConnected()) {
                return null;
            }
            String message = response.message();
            if (TextUtils.isEmpty((CharSequence)message)) {
                message = "OK";
            }
            try {
                webResourceResponse.setStatusCodeAndReasonPhrase(response.code(), message);
            }
            catch (Exception e) {
                return null;
            }
            webResourceResponse.setResponseHeaders(NetUtils.INSTANCE.multimapToSingle(response.headers().toMultimap()));
            return webResourceResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final boolean checkUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        if (!StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            return false;
        }
        String extension = MimeTypeMapUtils.INSTANCE.getFileExtensionFromUrl(url);
        if (TextUtils.isEmpty((CharSequence)extension)) {
            return false;
        }
        if (this.mCacheExtensionConfig.isMedia(extension)) {
            return false;
        }
        return this.mCacheExtensionConfig.canCache(extension);
    }

    private final void addHeader(Request.Builder reqBuilder, Map<String, String> headers) {
        block1: {
            Map<String, String> map = headers;
            if (map == null) break block1;
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                if (entry.getKey() == null || entry.getValue() == null) continue;
                String string = entry.getKey();
                Intrinsics.checkNotNull((Object)string);
                String string2 = entry.getValue();
                Intrinsics.checkNotNull((Object)string2);
                reqBuilder.addHeader(string, string2);
            }
        }
    }
}

