/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J$\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0014\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/transsion/lib_web/zip/utils/ZipUtils;", "", "()V", "CACHE_SIZE", "", "CHINESE_CHARSET", "", "UnZipFolder", "", "zipPath", "saveFilePath", "ensureZipPathSafety", "outputFile", "Ljava/io/File;", "destDirectory", "unZip", "zipFilePath", "destDir", "zip", "sourceFolder", "zipFile", "parentFile", "basePath", "zos", "Lorg/apache/tools/zip/ZipOutputStream;", "inputFile", "lib_web_release"})
@SourceDebugExtension(value={"SMAP\nZipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtils.kt\ncom/transsion/lib_web/zip/utils/ZipUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class ZipUtils {
    @NotNull
    public static final ZipUtils INSTANCE = new ZipUtils();
    @NotNull
    private static final String CHINESE_CHARSET = "GBK";
    private static final int CACHE_SIZE = 1024;

    private ZipUtils() {
    }

    public final void zip(@Nullable String sourceFolder, @Nullable String zipFilePath) throws Exception {
        OutputStream out = new FileOutputStream(zipFilePath);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)bos);
        zos.setEncoding(CHINESE_CHARSET);
        File file = new File(sourceFolder);
        String basePath = null;
        basePath = file.isDirectory() ? file.getPath() : file.getParent();
        this.zipFile(file, basePath, zos);
        zos.closeEntry();
        zos.close();
        bos.close();
        out.close();
    }

    public final int zipFile(@Nullable String inputFile, @Nullable String basePath, @Nullable String outputFile) throws Exception {
        OutputStream out = new FileOutputStream(outputFile);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)bos);
        File file = new File(inputFile);
        this.zipFile(file, basePath, zos);
        zos.closeEntry();
        zos.close();
        bos.close();
        out.close();
        return 0;
    }

    private final void zipFile(File parentFile, String basePath, ZipOutputStream zos) throws Exception {
        File[] files = new File[]{};
        File file = parentFile;
        Intrinsics.checkNotNull((Object)file);
        if (file.isDirectory()) {
            File[] fileArray = parentFile.listFiles();
            Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"parentFile.listFiles()");
            files = fileArray;
        } else {
            files = new File[]{parentFile};
        }
        Object pathName = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        byte[] cache = new byte[1024];
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            int n2;
            File file2;
            File file3 = file2 = fileArray[i];
            Intrinsics.checkNotNull((Object)file3);
            if (file3.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)file2.getPath(), (String)"file.path");
                String string2 = basePath;
                Intrinsics.checkNotNull((Object)string2);
                n2 = string2.length() + 1;
                String string3 = string.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                pathName = string3 + "/";
                zos.putNextEntry(new ZipEntry((String)pathName));
                this.zipFile(file2, basePath, zos);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)file2.getPath(), (String)"file.path");
            String string4 = basePath;
            Intrinsics.checkNotNull((Object)string4);
            n2 = string4.length() + 1;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n2), (String)"this as java.lang.String).substring(startIndex)");
            is = new FileInputStream(file2);
            bis = new BufferedInputStream(is);
            zos.putNextEntry(new ZipEntry((String)pathName));
            int nRead = 0;
            while (true) {
                int it = n2 = bis.read(cache, 0, 1024);
                boolean bl = false;
                nRead = it;
                if (n2 == -1) break;
                zos.write(cache, 0, nRead);
            }
            bis.close();
            is.close();
        }
    }

    public final void unZip(@Nullable String zipFilePath, @NotNull String destDir) throws Exception {
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        ZipFile zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
        Enumeration emu = zipFile.getEntries();
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        File file = null;
        File parentFile = null;
        ZipEntry entry = null;
        String entryName = null;
        byte[] cache = new byte[1024];
        StringBuffer sb = new StringBuffer();
        while (emu.hasMoreElements()) {
            String string;
            Object e = emu.nextElement();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.apache.tools.zip.ZipEntry");
            entry = (ZipEntry)e;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getName(), (String)"entry.name");
            String string2 = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
            int n = StringsKt.lastIndexOf$default((CharSequence)string2, (String)"/", (int)0, (boolean)false, (int)6, null);
            int n2 = entry.getName().length();
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, n2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (entry.isDirectory()) {
                new File(destDir + entryName).mkdirs();
                continue;
            }
            bis = new BufferedInputStream(zipFile.getInputStream(entry));
            sb.delete(0, sb.length());
            sb.append(destDir).append(File.separator).append(entryName);
            file = new File(sb.toString());
            parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos, 1024);
            int nRead = 0;
            while (true) {
                int it = n = bis.read(cache, 0, 1024);
                boolean bl = false;
                nRead = it;
                if (n == -1) break;
                fos.write(cache, 0, nRead);
            }
            bos.flush();
            bos.close();
            fos.close();
            bis.close();
        }
        zipFile.close();
    }

    public final void ensureZipPathSafety(@NotNull File outputFile, @Nullable String destDirectory) throws Exception {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        String destDirCanonicalPath = new File(destDirectory).getCanonicalPath();
        String outputFilecanonicalPath = outputFile.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)outputFilecanonicalPath, (String)"outputFilecanonicalPath");
        Intrinsics.checkNotNullExpressionValue((Object)destDirCanonicalPath, (String)"destDirCanonicalPath");
        if (!StringsKt.startsWith$default((String)outputFilecanonicalPath, (String)destDirCanonicalPath, (boolean)false, (int)2, null)) {
            String string = "Found Zip Path Traversal Vulnerability with %s";
            Object[] objectArray = new Object[]{outputFilecanonicalPath};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new Exception(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void UnZipFolder(@Nullable String zipPath, @NotNull String saveFilePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)saveFilePath, (String)"saveFilePath");
        int count = 0;
        count = -1;
        File file = null;
        InputStream is = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipPath, CHINESE_CHARSET);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                byte[] buf = new byte[1024];
                Object e = entries.nextElement();
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.apache.tools.zip.ZipEntry");
                ZipEntry entry = (ZipEntry)e;
                Object filename = entry.getName();
                boolean ismkdir = false;
                String string = filename;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filename");
                if (StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)0, (boolean)false, (int)6, null) != -1) {
                    ismkdir = true;
                }
                filename = saveFilePath + File.separator + (String)filename;
                if (entry.isDirectory()) {
                    file = new File((String)filename);
                    file.mkdirs();
                    continue;
                }
                file = new File((String)filename);
                if (!file.exists() && ismkdir) {
                    Object object;
                    Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
                    int n = 0;
                    Object object2 = filename;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"filename");
                    int n2 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)object2), (String)"/", (int)0, (boolean)false, (int)6, null);
                    String string2 = ((String)object).substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    new File(string2).mkdirs();
                }
                file.createNewFile();
                is = zipFile.getInputStream(entry);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos, 1024);
                while (true) {
                    int n;
                    int it = n = is.read(buf);
                    boolean bl = false;
                    count = it;
                    if (n <= -1) break;
                    ((BufferedOutputStream)bos).write(buf, 0, count);
                }
                ((BufferedOutputStream)bos).flush();
                bos.close();
                fos.close();
                is.close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            try {
                throw ioe;
            }
            catch (Throwable throwable) {
                try {
                    FilterOutputStream filterOutputStream = bos;
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    FileOutputStream fileOutputStream = fos;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    InputStream inputStream = is;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    ZipFile zipFile2 = zipFile;
                    if (zipFile2 == null) throw throwable;
                    zipFile2.close();
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            FilterOutputStream filterOutputStream = bos;
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            FileOutputStream fileOutputStream = fos;
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            InputStream inputStream = is;
            if (inputStream != null) {
                inputStream.close();
            }
            zipFile.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

