package com.transsion.lib_web

import android.net.Uri

/**
 * @author: zhangxinbing
 * @date : 2025/2/20 11:48
 * @description: 原生H5页面导航头展示判断
 */
object H5BarUtil {

    /**
     * 是否展示原生导航栏
     *
     * 客户端需解析URL中的指定参数（如 &h5_bar=true ）。
     * 当参数为 true 时，页面隐藏客户端原生导航头。
     * 默认展示原生导航头。
     */
//    fun hideNavigationBar(url: String): Boolean {
//        return kotlin.runCatching {
//            val uri: Uri = Uri.parse(url)
//            // 获取所有的参数名称
//            //val parameterNames = uri.queryParameterNames
//            // 获取特定参数的值
//            val param1 = uri.getQueryParameter("h5_bar")
//            param1.toBoolean()
//        }.getOrElse {
//            true
//        }
//    }

    /**
     * 优化 /#/
     *
     * https://www.mocamocatech.com/m/#/partner/ready-loan?channel=moviebox1.1&h5_bar=true&web_unlock_key=web_unlock_value
     * 这里，# 标记了 URL 的片段部分（fragment identifier）。在 Android 的 Uri.parse() 中，# 后的内容通常不会被解析为查询参数，而是作为片段的一部分。
     */
    fun hideNavigationBar(url: String): Boolean {
        return kotlin.runCatching {
            val uri = Uri.parse(url)
            // 检查是否包含片段部分
            val query = uri.query ?: uri.fragment?.substringAfter("?")
            val param1 = Uri.parse("?$query").getQueryParameter("h5_bar")
            param1?.toBoolean() ?: false // 如果参数不存在，默认为 true
        }.getOrElse {
            println("Error parsing URL: ${it.message}")
            false
        }
    }

}