package com.transsion.lib_web

import android.content.Context
import android.content.Intent

/**
 * @author: zhangxinbing
 * @date : 2025/4/23 17:56
 * @description:
 */
object ParseDeeplinkManager {

    /**
     * deeplink跳转 --> 跳转失败看看是否配置了H5 --> 跳转H5
     * val deeplink = "http://play.google.com/store/apps/details?id=com.google.android.apps.maps"
     */
    fun deepLink(url: String?, context: Context?): Boolean {
        if (url.isNullOrEmpty()) {
            return false
        }

        // TODO 如果 deep link/app link 以http&https 开头 需要特殊处理的
        // 跳转GP商店
        if (url.startsWith("https://play.google.com/store/apps/") || url.startsWith("http://play.google.com/store/apps/")) {
            return jump(url, context)
        }

        // TODO 这里缺少一个动态下发的能力

        // 这里返回了 以http 开头的所有请求，其他以https:// 开头的 applink 也会被拦截
        if (url.startsWith("http")) {
            return false
        }

        // PS商店
//        if (url.startsWith("palmplay://thirdlauncher.com")) {
//            return jump(url, context)
//        }

        // 其他的全部按照 deeplink 来处理
        jump(url, context)
        return true
    }

    private fun jump(url: String, context: Context?): Boolean {
        return try {
            val intent: Intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            context?.startActivity(intent)
            true
        } catch (ignore: Exception) {
            ignore.printStackTrace()
            false
        }
    }

}