package com.transsion.lib_web.zip

import android.net.Network
import android.net.NetworkCapabilities
import com.blankj.utilcode.util.NetworkUtils
import com.tn.lib.util.networkinfo.NetworkUtil
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener
import com.transsion.lib_web.WebLogger
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 * @author: zhangxinbing
 * @date : 2024/12/16 10:27
 * @description: 监听网络变化
 */
internal object ObserveNetworkState : OnNetworkStatusChangedListener {

    private fun getClassTag(): String = javaClass.simpleName

    override fun onDisconnected() {
        // 网络断开的时候不做处理
    }

    override fun onConnected(network: Network, networkCapabilities: NetworkCapabilities) {
        // 网络重新链接的时候检查一下字幕下载
        WebLogger.logD("${getClassTag()} --> onConnected() --> 网络重新链接的时候检查一下字幕下载 --> 延迟5秒，优化网络抖动 .....")
        retryDownload("网络重新连接")
    }


    // =============================================================================================


    /**
     * 监听网络变化来重试字幕下载任务
     */
    fun setNetworkStateListener() {
        // TODO 需要监听网络的变化
        NetworkUtil.registerNetworkStatusChangedListener(this)
        // 冷启动的时候也需要检查一下是否有下载失败的字幕任务
        retryDownload("冷启动")
    }

    /**
     * retry
     */
    private fun retryDownload(msg: String? = null) {
        CoroutineScope(Dispatchers.IO).launch {

            // 延迟5秒，优化网络抖动
            delay(5000)

            // 无网络直接返回
            if (NetworkUtils.isConnected().not()) {
                return@launch
            }

            // 加载数据
            WebResManager.getWebResConfig()
        }
    }

}