package com.transsion.lib_web.zip.db

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update

/**
 * @author: zhangxinbing
 * @date : 2023/12/21 19:32
 * @description: Web资源数据库操作
 */
@Dao
interface WebResDao {

    /**
     * 获取所有广告计划
     */
    @Query("SELECT * FROM mb_web_res_db")
    suspend fun getAllItem(): List<WebViewCacheConfigData>

    @Query("SELECT * FROM mb_web_res_db WHERE scene =:scene")
    suspend fun getItem(scene: String): WebViewCacheConfigData?

    /**
     * 插入信息
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(itemBean: WebViewCacheConfigData)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(list: List<WebViewCacheConfigData>)

    /**
     * 更新信息
     */
    @Update
    suspend fun update(itemBean: WebViewCacheConfigData)

    /**
     * 删除所有信息
     */
    @Query("DELETE FROM mb_web_res_db")
    suspend fun deleteAll()

    @Delete
    suspend fun deleteList(items: List<WebViewCacheConfigData>)

    @Delete
    suspend fun deleteItem(items: WebViewCacheConfigData)

    /**
     * 根据主键查询数据
     */
    @Query("DELETE FROM mb_web_res_db WHERE scene =:scene")
    suspend fun deleteExpireVersion(scene: String)

}