package com.transsion.lib_web.zip.db

import android.os.Parcelable
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2024/12/10 20:35
 * @description: 服务端下发数据和本地数据库使用一个对象
 *
 * {
 *   "code": 0,
 *   "message": "string",
 *   "data": {
 *     "list": [
 *       {
 *         "scene": "string", // 主键
 *         "htmlUrl": "string",
 *         "zipUrl": "string",
 *         "zipMd5": "string",
 *         "sourceType": 0,
 *         "updateTime": "string"
 *       }
 *     ],
 *     "lastUpdateTime": "string"
 *   }
 * }
 */
@Parcelize
@Entity(tableName = "mb_web_res_db")
data class WebViewCacheConfigData(
    @PrimaryKey val scene: String,      // 场景
    val htmlUrl: String,                // 页面地址   "$scheme://$authority$path" url的三部分组成
    val zipUrl: String,                 // 压缩包地址
    val zipMd5: String,                 // 压缩包MD5
    val sourceType: Int,                // 资源类型
    val updateTime: String?,             // 更新时间戳，用于判断当前是否更新了信息
) : Parcelable