package com.transsion.lib_web.zip.loader

import android.text.TextUtils
import java.util.Locale

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 11:56
 * @description: 缓存扩展配置
 */
class CacheExtensionConfig {

    /**
     * 单独webview实例的
     */
    private val statics: HashSet<String> = HashSet(STATIC)

    /**
     *
     */
    private val no_cache: HashSet<String> = HashSet(NO_CACH)


    // =============================================================================================


    fun isMedia(extension: String): Boolean {
        if (TextUtils.isEmpty(extension)) {
            return false
        }
        return if (NO_CACH.contains(extension)) {
            true
        } else no_cache.contains(extension.lowercase(Locale.getDefault()).trim { it <= ' ' })
    }

    fun canCache(extension: String): Boolean {
        var ext = extension
        if (TextUtils.isEmpty(ext)) {
            return false
        }
        ext = ext.lowercase(Locale.getDefault()).trim { it <= ' ' }
        return if (STATIC.contains(ext)) {
            true
        } else statics.contains(ext)
    }

    fun addExtension(extension: String): CacheExtensionConfig {
        add(statics, extension)
        return this
    }

    fun removeExtension(extension: String): CacheExtensionConfig {
        remove(statics, extension)
        return this
    }

    fun isHtml(extension: String): Boolean {
        if (TextUtils.isEmpty(extension)) {
            return false
        }
        return extension.lowercase(Locale.getDefault()).contains("html") || extension.lowercase(
            Locale.getDefault()
        ).contains("htm")
    }

    fun clearAll() {
        clearDiskExtension()
    }

    fun clearDiskExtension() {
        statics.clear()
    }

    companion object {
        //全局默认的
        private val STATIC: HashSet<String> = object : HashSet<String>() {
            init {
                add("html")
                add("htm")
                add("js")
                add("ico")
                add("css")
                add("png")
                add("jpg")
                add("jpeg")
                add("gif")
                add("bmp")
                add("ttf")
                add("woff")
                add("woff2")
                add("otf")
                add("eot")
                add("svg")
                add("xml")
                add("swf")
                add("txt")
                add("text")
                add("conf")
                add("webp")
            }
        }
        private val NO_CACH: HashSet<String> = object : HashSet<String>() {
            init {
                add("mp4")
                add("mp3")
                add("ogg")
                add("avi")
                add("wmv")
                add("flv")
                add("rmvb")
                add("3gp")
            }
        }

        fun addGlobalExtension(extension: String) {
            add(STATIC, extension)
        }

        fun removeGlobalExtension(extension: String) {
            remove(STATIC, extension)
        }

        private fun add(set: HashSet<String>, extension: String) {
            if (TextUtils.isEmpty(extension)) {
                return
            }
            set.add(extension.replace(".", "").lowercase(Locale.getDefault()).trim { it <= ' ' })
        }

        private fun remove(set: HashSet<*>, extension: String) {
            if (TextUtils.isEmpty(extension)) {
                return
            }
            set.remove(extension.replace(".", "").lowercase(Locale.getDefault()).trim { it <= ' ' })
        }
    }
}