package com.transsion.lib_web.zip.loader

import okhttp3.OkHttpClient
import java.util.concurrent.TimeUnit

/**
 * @author: zhangxinbing
 * @date : 2024/12/12 10:03
 * @description:
 */
object OkHttpProvider {

    /**
     * 这个可以使用网络库提供的客户端
     */
    private val client by lazy {
        OkHttpClient.Builder().connectTimeout(30, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS).readTimeout(30, TimeUnit.SECONDS)
            //.retryOnConnectionFailure(true)
            .cache(null) // 关闭请求缓存后，每次发送请求都会直接从服务器获取最新的数据，而不会使用之前缓存的数据。
            .build()
    }

    fun getOkHttpClient(): OkHttpClient = client

}