package com.transsion.lib_web.zip.loader

import android.content.Context
import android.text.TextUtils
import android.webkit.URLUtil.isValidUrl
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebView
import com.transsion.lib_web.zip.utils.NetUtils

/**
 * @author: zhangxinbing
 * @date : 2024/12/11 11:58
 * @description:
 */
class WebViewLoaderManager(val context: Context, private val loaders: List<WebViewLoader>) {

    private var mOrigin = ""
    private var mReferer = ""
    private var mUserAgent = ""

    fun interceptRequest(request: WebResourceRequest?): WebResourceResponse? {
        return interceptRequest(request?.url.toString(), request?.requestHeaders ?: buildHeaders())
    }

    fun interceptRequest(
        url: String?, headers: MutableMap<String, String> = buildHeaders()
    ): WebResourceResponse? {
        url?.let {
            loaders.forEach { loader ->
                val response = loader.interceptRequest(it, headers)
                if (null != response) {
                    return response
                }
            }
        }
        return null
    }

    fun loadUrl(webView: WebView?, url: String?) {
        if (null == url) {
            return
        }
        if (!isValidUrl(url)) {
            return
        }
        webView?.loadUrl(url)
        mReferer = webView?.url ?: ""
        mOrigin = NetUtils.getOriginUrl(mReferer) ?: ""
        mUserAgent = webView?.settings?.userAgentString ?: ""
    }

    fun loadUrl(url: String, userAgent: String) {
        if (!isValidUrl(url)) {
            return
        }
        mReferer = url
        mOrigin = NetUtils.getOriginUrl(mReferer) ?: ""
        mUserAgent = userAgent
    }

    fun loadUrl(url: String, additionalHttpHeaders: Map<String?, String?>?, userAgent: String) {
        if (!isValidUrl(url)) {
            return
        }
        mReferer = url
        mOrigin = NetUtils.getOriginUrl(mReferer) ?: ""
        mUserAgent = userAgent
    }

    fun loadUrl(webView: WebView, url: String?, additionalHttpHeaders: Map<String?, String?>?) {
        if (!isValidUrl(url)) {
            return
        }
        webView.loadUrl(url!!, additionalHttpHeaders!!)
        mReferer = webView.url ?: ""
        mOrigin = NetUtils.getOriginUrl(mReferer) ?: ""
        mUserAgent = webView.settings.userAgentString
    }

    fun buildHeaders(): MutableMap<String, String> {
        val headers: MutableMap<String, String> = HashMap()
        if (!TextUtils.isEmpty(mOrigin)) {
            headers["Origin"] = mOrigin
        }
        if (!TextUtils.isEmpty(mReferer)) {
            headers["Referer"] = mReferer
        }
        if (!TextUtils.isEmpty(mUserAgent)) {
            headers["User-Agent"] = mUserAgent
        }
        return headers
    }

    fun isUserCache(): Boolean {
        return loaders.firstOrNull { it is WebViewFileCacheLoader }?.let {
            it as WebViewFileCacheLoader?
        }?.userCache ?: false
    }

    fun getZipMd5(): String? {
        return loaders.firstOrNull { it is WebViewFileCacheLoader }?.let {
            it as WebViewFileCacheLoader?
        }?.zipMD5
    }

}