package com.transsion.lib_web.zip.utils

import android.os.Environment
import android.text.TextUtils
import android.util.Log
import java.io.BufferedReader
import java.io.File
import java.io.FileInputStream
import java.io.FileNotFoundException
import java.io.FileOutputStream
import java.io.FilenameFilter
import java.io.IOException
import java.io.InputStream
import java.io.InputStreamReader
import java.io.PrintStream


class FileUtils {
    /**
     * 删除指定目录下的文件，这里用于缓存的删除
     *
     * @param filePath filePath
     */
    private fun deleteFolder(filePath: String) {
        if (TextUtils.isEmpty(filePath)) {
            return
        }
        try {
            val file = File(filePath)
            if (file.isDirectory) {
                val files = file.listFiles()
                for (subFile in files) {
                    deleteFolder(subFile.absolutePath)
                }
            }
            file.delete()
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    companion object {
        fun deleteFiles(folder: File, filter: FilenameFilter?): Long {
            val size: Long = 0
            try {
                val fileList = folder.listFiles(filter) ?: return size
                for (file in fileList) {
                    if (file.isDirectory) {
                        deleteFiles(file, filter)
                    } else if (file.isFile) {
                        file.delete()
                    }
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return size
        }

        fun deleteFile(file: File) {
            try {
                if (file.isDirectory) {
                    val fileList = file.listFiles()
                    if (fileList != null) {
                        for (childFile in fileList) {
                            deleteFile(childFile)
                        }
                    }
                }
                file.delete()
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        fun getFilterPath(path: String?): File? {
            if (!TextUtils.isEmpty(path)) {
                val dir = File(path)
                if (dir.isDirectory) {
                    val files = dir.listFiles()
                    if (files != null && files.isNotEmpty()) {
                        for (file in files) {
                            if (file.absolutePath.contains("LUT.png")) {
                                return file
                            }
                        }
                    }
                }
            }
            return null
        }

        fun deleteFile(path: String?) {
            if (path.isNullOrEmpty()) {
                return
            }
            try {
                val file = File(path)
                if (file.exists()) {
                    file.delete()
                }
            } catch (e: Exception) {
            }
        }

        fun fileIsExists(path: String?): Boolean {
            if (path.isNullOrEmpty()) return false
            val file = File(path)
            return file.exists()
        }

        /**
         * 根据路径获取文件名
         */
        fun getFileNameByPath(path: String): String {
            var name = ""
            if (!path.isNullOrEmpty()) {
                val dotIndex = path.lastIndexOf("/")
                if (dotIndex > 0) {
                    /* 获取文件的后缀名*/
                    name = path.substring(dotIndex + 1, path.length)
                }
            }
            return name
        }

        /**
         * 获取文件后缀名 带“.”的
         */
        fun getExtensionName(filename: String?): String {
            var extensionName = ""
            if (!filename.isNullOrEmpty()) {
                val dot = filename.lastIndexOf('.')
                if ((dot > -1 && dot < (filename.length - 1))) {
                    extensionName = filename.substring(dot)
                    return extensionName
                }
            }
            return extensionName
        }

        fun getFileNoExtensionName(f: String?): String? {
            var fileName = f
            if (!fileName.isNullOrEmpty()) {
                val dot = fileName.lastIndexOf('.')
                if (dot > -1 && dot < fileName.length - 1) {
                    fileName = fileName.substring(0, dot)
                }
            }
            return fileName
        }

        fun getFileParentByPath(path: String?): String {
            var parentPath = ""
            if (!path.isNullOrEmpty()) {
                val dotIndex = path.lastIndexOf("/")
                if (dotIndex > 0) {
                    /* 获取文件的后缀名*/
                    parentPath = path.substring(0, dotIndex)
                }
            }
            return parentPath
        }

        fun saveFile(data: String?, filePath: String?) {
            if (filePath.isNullOrEmpty()) {
                return
            }
            if (Environment.getExternalStorageState() != Environment.MEDIA_MOUNTED) { //SD卡不存在则不操作
                return  //返回到程序的被调用处
            }
            //File file = new File(JSON_CACHE+"sent_file_json.txt");//要输出的文件路径
            val file = File(filePath) //要输出的文件路径
            if (!file.parentFile.exists()) { //文件夹不存在
                file.parentFile.mkdirs() //创建文件夹
            }
            var out: PrintStream? = null
            try {
                out = PrintStream(FileOutputStream(file))
                out.print(data)
            } catch (e: FileNotFoundException) {
                e.printStackTrace()
            } finally {
                out?.close()
            }
        }

        fun getFile(filePath: String?): String {
            if (filePath.isNullOrEmpty()) {
                return ""
            }
            if (Environment.getExternalStorageState() != Environment.MEDIA_MOUNTED) { //SD卡不存在则不操作
                return ""
            }
            val file = File(filePath) //要输出的文件路径
            if (!file.exists()) {
                return ""
            }
            val stringBuilder = StringBuilder()
            var `in`: InputStream? = null
            try {
                `in` = FileInputStream(file)
                val bufferedReader = BufferedReader(InputStreamReader(`in`))
                var line: String? = null
                while (bufferedReader.readLine().also { line = it } != null) {
                    stringBuilder.append(line)
                }
                `in`.close() //关闭输出
            } catch (e: FileNotFoundException) {
                e.printStackTrace()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            return stringBuilder.toString()
        }

        /**
         * 获取指定文件夹
         *
         * @param f
         * @return
         * @throws Exception
         */
        @Throws(Exception::class)
        private fun getFileSizes(f: File): Long {
            var size: Long = 0
            val flist = f.listFiles()
            for (i in flist.indices) {
                size = if (flist[i].isDirectory) {
                    size + getFileSizes(flist[i])
                } else {
                    size + getFileSize(flist[i])
                }
            }
            return size
        }

        /**
         * 获取指定文件大小
         *
         * @param file
         * @return
         * @throws Exception
         */
        @Throws(Exception::class)
        private fun getFileSize(file: File): Long {
            var size: Long = 0
            if (file.exists()) {
                var fis: FileInputStream? = null
                fis = FileInputStream(file)
                size = fis.available().toLong()
            } else {
                file.createNewFile()
                Log.e("获取文件大小", "文件不存在!")
            }
            return size
        }
    }
}