package com.transsion.lib_web.zip.utils

import android.text.TextUtils
import android.webkit.MimeTypeMap
import java.util.Locale

/**
 * Created by yale on 2018/1/9.
 */
object MimeTypeMapUtils {
    fun getFileExtensionFromUrl(url: String): String {
        var newUrl = url.lowercase(Locale.getDefault())
        if (!TextUtils.isEmpty(newUrl)) {
            val fragment = newUrl.lastIndexOf('#')
            if (fragment > 0) {
                newUrl = newUrl.substring(0, fragment)
            }
            val query = newUrl.lastIndexOf('?')
            if (query > 0) {
                newUrl = newUrl.substring(0, query)
            }
            val filenamePos = newUrl.lastIndexOf('/')
            val filename = if (0 <= filenamePos) newUrl.substring(filenamePos + 1) else newUrl
            if (filename.isNotEmpty()) {
                val dotPos = filename.lastIndexOf('.')
                if (0 <= dotPos) {
                    return filename.substring(dotPos + 1)
                }
            }
        }
        return ""
    }

    fun getMimeTypeFromUrl(url: String): String? {
        val extension = getFileExtensionFromUrl(url)
        var mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)
        if (null == mimeType && TextUtils.equals(extension, "js")) {
            mimeType = "application/javascript"
        }
        return mimeType
    }

    fun getMimeTypeFromExtension(extension: String?): String? {
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)
    }
}