/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip;

import android.content.Context;
import com.blankj.utilcode.util.EncryptUtils;
import com.transsion.lib_web.zip.db.WebViewCacheConfigData;
import com.transsion.lib_web.zip.loader.WebViewCacheTask;
import com.transsion.lib_web.zip.loader.WebViewFileCacheLoaderKt;
import com.transsion.lib_web.zip.utils.FileUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Lcom/transsion/lib_web/zip/WebViewCacheDownloader;", "", "<init>", "()V", "getWebViewCacheFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "checkDownloadZip", "", "dbItem", "Lcom/transsion/lib_web/zip/db/WebViewCacheConfigData;", "(Landroid/content/Context;Lcom/transsion/lib_web/zip/db/WebViewCacheConfigData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocalFile", "configData", "clearCacheFile", "cacheConfigData", "LibWeb_release"})
public final class WebViewCacheDownloader {
    @NotNull
    public static final WebViewCacheDownloader INSTANCE = new WebViewCacheDownloader();

    private WebViewCacheDownloader() {
    }

    @NotNull
    public final File getWebViewCacheFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new File(context.getCacheDir(), "webViewCache");
    }

    @Nullable
    public final Object checkDownloadZip(@NotNull Context context, @NotNull WebViewCacheConfigData dbItem, @NotNull Continuation<? super Unit> $completion) {
        if (((CharSequence)dbItem.getZipUrl()).length() == 0) {
            return Unit.INSTANCE;
        }
        Object object = new WebViewCacheTask(context, dbItem).start($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final File getLocalFile(@NotNull Context context, @NotNull WebViewCacheConfigData configData) {
        String baseUrl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configData, (String)"configData");
        String string = baseUrl = WebViewFileCacheLoaderKt.getBaseUrl(configData.getHtmlUrl());
        boolean bl = string != null ? ((CharSequence)string).length() == 0 : false;
        if (bl) {
            return null;
        }
        return new File(this.getWebViewCacheFile(context), EncryptUtils.encryptMD5ToString((String)baseUrl) + "_" + configData.getZipMd5());
    }

    public final void clearCacheFile(@NotNull Context context, @NotNull WebViewCacheConfigData cacheConfigData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheConfigData, (String)"cacheConfigData");
        try {
            File localFile;
            boolean bl = false;
            File file = localFile = INSTANCE.getLocalFile(context, cacheConfigData);
            boolean bl2 = file != null ? file.exists() : false;
            if (bl2) {
                FileUtils.Companion.deleteFile(localFile);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

