/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.loader;

import android.content.Context;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.FutureTarget;
import com.transsion.lib_web.WebLogger;
import com.transsion.lib_web.zip.loader.WebViewLoader;
import com.transsion.lib_web.zip.utils.MimeTypeMapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/transsion/lib_web/zip/loader/WebViewGlideLoader;", "Lcom/transsion/lib_web/zip/loader/WebViewLoader;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "interceptRequest", "Landroid/webkit/WebResourceResponse;", "request", "Landroid/webkit/WebResourceRequest;", "url", "", "headers", "", "getCachePath", "Ljava/io/File;", "clearCache", "", "LibWeb_release"})
public final class WebViewGlideLoader
implements WebViewLoader {
    @NotNull
    private final Context context;

    public WebViewGlideLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable WebResourceRequest request) {
        WebResourceRequest webResourceRequest = request;
        String string = webResourceRequest != null && (webResourceRequest = webResourceRequest.getUrl()) != null ? webResourceRequest.toString() : null;
        Object object = request;
        if (object == null || (object = object.getRequestHeaders()) == null) {
            object = new HashMap();
        }
        return this.interceptRequest(string, (Map<String, String>)object);
    }

    @Override
    @Nullable
    public WebResourceResponse interceptRequest(@Nullable String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        if (url == null) {
            return null;
        }
        try {
            String mimeType;
            String string = mimeType = MimeTypeMapUtils.INSTANCE.getMimeTypeFromUrl(url);
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"image/", (boolean)false, (int)2, null) : false;
            if (bl) {
                FutureTarget futureTarget = Glide.with((Context)this.context).asFile().load(url).submit();
                Intrinsics.checkNotNullExpressionValue((Object)futureTarget, (String)"submit(...)");
                FutureTarget submit = futureTarget;
                InputStream inputStream = new FileInputStream((File)submit.get());
                WebLogger.INSTANCE.logD("WebViewGlideLoader --> interceptRequest() --> glide file   \nurl = " + url + "  \nmimeType = " + mimeType);
                return new WebResourceResponse(mimeType, "", 200, "OK", (Map)WebViewLoader.Companion.getResponseHeaders(), inputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    @Nullable
    public File getCachePath() {
        return null;
    }

    @Override
    public void clearCache() {
    }
}

