/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.utils;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\n"}, d2={"Lcom/transsion/lib_web/zip/utils/MimeTypeMapUtils;", "", "<init>", "()V", "getFileExtensionFromUrl", "", "url", "getMimeTypeFromUrl", "getMimeTypeFromExtension", "extension", "LibWeb_release"})
public final class MimeTypeMapUtils {
    @NotNull
    public static final MimeTypeMapUtils INSTANCE = new MimeTypeMapUtils();

    private MimeTypeMapUtils() {
    }

    @NotNull
    public final String getFileExtensionFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String newUrl = string2;
        if (!TextUtils.isEmpty((CharSequence)newUrl)) {
            int dotPos;
            String filename;
            int filenamePos;
            int query;
            int fragment = StringsKt.lastIndexOf$default((CharSequence)newUrl, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (fragment > 0) {
                String string3 = newUrl.substring(0, fragment);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                newUrl = string3;
            }
            if ((query = StringsKt.lastIndexOf$default((CharSequence)newUrl, (char)'?', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string4 = newUrl.substring(0, query);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                newUrl = string4;
            }
            if (0 <= (filenamePos = StringsKt.lastIndexOf$default((CharSequence)newUrl, (char)'/', (int)0, (boolean)false, (int)6, null))) {
                String string5 = newUrl.substring(filenamePos + 1);
                v5 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                v5 = filename = newUrl;
            }
            if (((CharSequence)filename).length() > 0 && 0 <= (dotPos = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null))) {
                String string6 = filename.substring(dotPos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                return string6;
            }
        }
        return "";
    }

    @Nullable
    public final String getMimeTypeFromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String extension = this.getFileExtensionFromUrl(url);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        if (mimeType == null && TextUtils.equals((CharSequence)extension, (CharSequence)"js")) {
            mimeType = "application/javascript";
        }
        return mimeType;
    }

    @Nullable
    public final String getMimeTypeFromExtension(@Nullable String extension) {
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }
}

