/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.blankj.utilcode.util.GsonUtils;
import com.github.lzyzsd.jsbridge.BridgeWebView;
import com.tn.lib.util.networkinfo.NetworkUtil;
import com.transsion.base.report.athena.Report;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0003J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/transsion/lib_web/cache/TWebViewProvider;", "", "<init>", "()V", "logCache", "", "msg", "", "report", "url", "action", "getWebView", "Lcom/github/lzyzsd/jsbridge/BridgeWebView;", "applicationContext", "Landroid/content/Context;", "initSettings", "webView", "initWebOptions", "loadFinish", "LibWeb_release"})
public final class TWebViewProvider {
    @NotNull
    public static final TWebViewProvider INSTANCE = new TWebViewProvider();

    private TWebViewProvider() {
    }

    public final void logCache(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Log.i((String)"zxb_cache_log", (String)msg);
    }

    public final void report(@NotNull String url, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Map map = new LinkedHashMap();
        map.put("url", url);
        map.put("action", action);
        Report.INSTANCE.reportEventV2("preload", map, "web");
        this.logCache("\u4e0a\u62a5 --> action = " + action + " --> url = " + url);
    }

    @NotNull
    public final BridgeWebView getWebView(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        BridgeWebView webView = new BridgeWebView(applicationContext);
        this.initWebOptions(webView);
        this.initSettings(webView);
        return webView;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void initSettings(BridgeWebView webView) {
        WebSettings webSettings;
        WebSettings $this$initSettings_u24lambda_u240 = webSettings = webView.getSettings();
        boolean bl = false;
        $this$initSettings_u24lambda_u240.setJavaScriptEnabled(true);
        $this$initSettings_u24lambda_u240.setSupportZoom(true);
        $this$initSettings_u24lambda_u240.setBuiltInZoomControls(false);
        Context context = webView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        $this$initSettings_u24lambda_u240.setCacheMode(NetworkUtil.INSTANCE.isNetworkConnected(context) ? -1 : 1);
        $this$initSettings_u24lambda_u240.setMixedContentMode(0);
        $this$initSettings_u24lambda_u240.setTextZoom(100);
        $this$initSettings_u24lambda_u240.setDatabaseEnabled(true);
        $this$initSettings_u24lambda_u240.setLoadsImagesAutomatically(true);
        $this$initSettings_u24lambda_u240.setSupportMultipleWindows(false);
        $this$initSettings_u24lambda_u240.setBlockNetworkImage(false);
        $this$initSettings_u24lambda_u240.setAllowFileAccess(true);
        $this$initSettings_u24lambda_u240.setJavaScriptCanOpenWindowsAutomatically(true);
        $this$initSettings_u24lambda_u240.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        $this$initSettings_u24lambda_u240.setLoadWithOverviewMode(false);
        $this$initSettings_u24lambda_u240.setUseWideViewPort(false);
        $this$initSettings_u24lambda_u240.setDomStorageEnabled(true);
        $this$initSettings_u24lambda_u240.setNeedInitialFocus(true);
        $this$initSettings_u24lambda_u240.setDefaultTextEncodingName("utf-8");
        $this$initSettings_u24lambda_u240.setDefaultFontSize(16);
        $this$initSettings_u24lambda_u240.setMinimumFontSize(12);
        $this$initSettings_u24lambda_u240.setGeolocationEnabled(true);
    }

    private final void initWebOptions(BridgeWebView webView) {
        BridgeWebView bridgeWebView;
        BridgeWebView $this$initWebOptions_u24lambda_u241 = bridgeWebView = webView;
        boolean bl = false;
        $this$initWebOptions_u24lambda_u241.setGson(GsonUtils.getGson());
        $this$initWebOptions_u24lambda_u241.setLayerType(2, null);
        $this$initWebOptions_u24lambda_u241.setOverScrollMode(2);
        webView.setWebViewClient(new WebViewClient(webView){
            final /* synthetic */ BridgeWebView $webView;
            {
                this.$webView = $webView;
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                boolean bl;
                Object urlString;
                Object object = request;
                if (object == null || (object = object.getUrl()) == null || (object = object.toString()) == null) {
                    object = "";
                }
                if (!(StringsKt.startsWith$default((String)(urlString = object), (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)urlString, (String)"https", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)urlString, (String)"file", (boolean)false, (int)2, null))) {
                    try {
                        WebView webView = view;
                        TWebViewProvider.access$loadFinish(TWebViewProvider.INSTANCE, this.$webView, webView != null ? webView.getUrl() : null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                String urlString = url;
                if (!(StringsKt.startsWith$default((String)urlString, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)urlString, (String)"https", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)urlString, (String)"file", (boolean)false, (int)2, null))) {
                    try {
                        TWebViewProvider.access$loadFinish(TWebViewProvider.INSTANCE, this.$webView, url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                TWebViewProvider.access$loadFinish(TWebViewProvider.INSTANCE, this.$webView, url);
            }
        });
    }

    private final void loadFinish(BridgeWebView webView, String url) {
        Boolean tag;
        Object object = webView.getTag(-1001);
        Boolean bl = tag = object instanceof Boolean ? (Boolean)object : null;
        if (Intrinsics.areEqual((Object)tag, (Object)true)) {
            webView.setTag(-1001, false);
            String string = url;
            if (string == null) {
                string = "";
            }
            this.report(string, "finish");
        }
    }

    public static final /* synthetic */ void access$loadFinish(TWebViewProvider $this, BridgeWebView webView, String url) {
        $this.loadFinish(webView, url);
    }
}

