/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.lib_web.zip.utils;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/transsion/lib_web/zip/utils/FileUtils;", "", "<init>", "()V", "deleteFolder", "", "filePath", "", "Companion", "LibWeb_release"})
public final class FileUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void deleteFolder(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return;
        }
        try {
            File file = new File(filePath);
            if (file.isDirectory()) {
                Object[] files = file.listFiles();
                Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
                while (iterator.hasNext()) {
                    File subFile = (File)iterator.next();
                    String string = subFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    this.deleteFolder(string);
                }
            }
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0017\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/transsion/lib_web/zip/utils/FileUtils$Companion;", "", "<init>", "()V", "deleteFiles", "", "folder", "Ljava/io/File;", "filter", "Ljava/io/FilenameFilter;", "deleteFile", "", "file", "getFilterPath", "path", "", "fileIsExists", "", "getFileNameByPath", "getExtensionName", "filename", "getFileNoExtensionName", "f", "getFileParentByPath", "saveFile", "data", "filePath", "getFile", "getFileSizes", "getFileSize", "LibWeb_release"})
    @SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/transsion/lib_web/zip/utils/FileUtils$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1#2:260\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long deleteFiles(@NotNull File folder, @Nullable FilenameFilter filter) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            long size = 0L;
            try {
                File[] fileArray = folder.listFiles(filter);
                if (fileArray == null) {
                    return size;
                }
                for (File file : fileArray) {
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNull((Object)file);
                        this.deleteFiles(file, filter);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    file.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return size;
        }

        public final void deleteFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                Object[] fileList;
                if (file.isDirectory() && (fileList = file.listFiles()) != null) {
                    Iterator iterator = ArrayIteratorKt.iterator((Object[])fileList);
                    while (iterator.hasNext()) {
                        File childFile = (File)iterator.next();
                        Intrinsics.checkNotNull((Object)childFile);
                        this.deleteFile(childFile);
                    }
                }
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Nullable
        public final File getFilterPath(@Nullable String path) {
            Object[] files;
            File dir;
            if (!TextUtils.isEmpty((CharSequence)path) && (dir = new File(path)).isDirectory() && (files = dir.listFiles()) != null && !(files.length == 0)) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    String string = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"LUT.png", (boolean)false, (int)2, null)) continue;
                    return file;
                }
            }
            return null;
        }

        public final void deleteFile(@Nullable String path) {
            CharSequence charSequence = path;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            try {
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final boolean fileIsExists(@Nullable String path) {
            CharSequence charSequence = path;
            if (charSequence == null || charSequence.length() == 0) {
                return false;
            }
            File file = new File(path);
            return file.exists();
        }

        @NotNull
        public final String getFileNameByPath(@NotNull String path) {
            int dotIndex;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String name = "";
            if (!(((CharSequence)path).length() == 0) && (dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = path.substring(dotIndex + 1, path.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                name = string;
            }
            return name;
        }

        @NotNull
        public final String getExtensionName(@Nullable String filename) {
            int dot;
            String extensionName = "";
            CharSequence charSequence = filename;
            if (!(charSequence == null || charSequence.length() == 0) && (dot = StringsKt.lastIndexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null)) > -1 && dot < filename.length() - 1) {
                String string = filename.substring(dot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                extensionName = string;
                return extensionName;
            }
            return extensionName;
        }

        @Nullable
        public final String getFileNoExtensionName(@Nullable String f) {
            int dot;
            String fileName = f;
            CharSequence charSequence = fileName;
            if (!(charSequence == null || charSequence.length() == 0) && (dot = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null)) > -1 && dot < fileName.length() - 1) {
                String string = fileName.substring(0, dot);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                fileName = string;
            }
            return fileName;
        }

        @NotNull
        public final String getFileParentByPath(@Nullable String path) {
            int dotIndex;
            String parentPath = "";
            CharSequence charSequence = path;
            if (!(charSequence == null || charSequence.length() == 0) && (dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = path.substring(0, dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                parentPath = string;
            }
            return parentPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void saveFile(@Nullable String data, @Nullable String filePath) {
            CharSequence charSequence = filePath;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            if (!Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted")) {
                return;
            }
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            PrintStream out = null;
            try {
                out = new PrintStream(new FileOutputStream(file));
                out.print(data);
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                PrintStream printStream = out;
                if (printStream != null) {
                    printStream.close();
                }
            }
        }

        @NotNull
        public final String getFile(@Nullable String filePath) {
            CharSequence charSequence = filePath;
            if (charSequence == null || charSequence.length() == 0) {
                return "";
            }
            if (!Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted")) {
                return "";
            }
            File file = new File(filePath);
            if (!file.exists()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            InputStream in = null;
            try {
                in = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while (true) {
                    String string;
                    String it = string = bufferedReader.readLine();
                    boolean bl = false;
                    line = it;
                    if (string == null) break;
                    stringBuilder.append(line);
                }
                ((FileInputStream)in).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final long getFileSizes(File f) throws Exception {
            long size = 0L;
            File[] flist = f.listFiles();
            int n = flist.length;
            for (int i = 0; i < n; ++i) {
                long l;
                if (flist[i].isDirectory()) {
                    File file = flist[i];
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(...)");
                    l = size + this.getFileSizes(file);
                } else {
                    File file = flist[i];
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(...)");
                    l = size + this.getFileSize(file);
                }
                size = l;
            }
            return size;
        }

        private final long getFileSize(File file) throws Exception {
            long size = 0L;
            if (file.exists()) {
                FileInputStream fis = null;
                fis = new FileInputStream(file);
                size = fis.available();
            } else {
                file.createNewFile();
                Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            return size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

