package com.tn.lib.net

import android.app.Application
import android.util.Log

/**
 * 配置基础信息
 */
class Http {

    companion object {
        /**
         * adb shell setprop log.tag.net_proxy_tag D
         */
        const val NET_PROXY_TAG = "net_proxy_tag"
        var application: Application? = null
        var netConfig: NetConfig? = null

        fun setConfig(application: Application, netConfig: NetConfig?) {
            this.application = application
            this.netConfig = netConfig
        }

        fun setDebug(debug: Boolean) {
            netConfig?.isDebug = debug
        }

        fun isDebug(): Boolean {
            return netConfig?.isDebug ?: false || Log.isLoggable(NET_PROXY_TAG, Log.DEBUG)
        }



        var  DEV_TO_ONLINE = false
        fun setDevToOnline(devtoOnline: Boolean){
            DEV_TO_ONLINE = devtoOnline
        }

        /**
         * 当前网络是否为dev环境，release包此变量无效
         * @return Boolean
         */
        fun isDev(): Boolean {
            if (DEV_TO_ONLINE) {
                return false
            }
            return netConfig?.isDev ?: false
        }
    }

}