package com.tn.lib.net.bean

import com.google.gson.annotations.SerializedName
import java.io.Serializable

/**
 * 服务器返回的通用字段结构
 */
open class BaseDto<T> : Serializable {

    @SerializedName("message")
    var msg: String = ""
    @SerializedName("code")
    var code: String = ""
    @SerializedName("data")
    var data: T? = null
    @SerializedName("reason")
    var reason: String = ""

    constructor()
    constructor(msg: String, code: String, data: T?, reason: String) {
        this.msg = msg
        this.code = code
        this.data = data
        this.reason = reason
    }

    override fun toString(): String {
        return "BaseDto(msg='$msg', code='$code', data=$data, reason=$reason)"
    }

}