package com.tn.lib.net.convert;

import com.tn.lib.net.annotation.NoCode;
import com.tn.lib.net.cons.NetConst;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class FastJsonConverterFactory extends Converter.Factory {

    public static FastJsonConverterFactory create() {
        return new FastJsonConverterFactory();
    }

    /**
     * 需要重写父类中responseBodyConverter，该方法用来转换服务器返回数据
     */
    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        return new FastJsonResponseBodyConverter<>(type,getCodeKey(annotations));
    }

    /**
     * 需要重写父类中responseBodyConverter，该方法用来转换发送给服务器的数据
     */
    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return new FastJsonRequestBodyConverter<>();
    }

    private String getCodeKey(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return "no_code";
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof NoCode) {
                return NetConst.NO_CODE;
            }
        }
        return "no_code";
    }

}