package com.tn.lib.net.dns

import java.net.InetAddress

class DnsParse {
    companion object {
        fun buildAddress(list: List<String>?, hostname: String): List<InetAddress> {
            val addresses: MutableList<InetAddress> = ArrayList()
            if (list != null) {
                for (ip in list) {
                    val ipStr = ip.split("\\.".toRegex()).toTypedArray()
                    val ipBuf = ByteArray(4)
                    for (i in 0..3) {
                        ipBuf[i] = (ipStr[i].toInt() and 0xff).toByte()
                    }
                    addresses.add(InetAddress.getByAddress(hostname, ipBuf))
                }
            }
            return addresses
        }

        fun buildAddress(list: Array<String>, hostname: String): List<InetAddress>? {
            val addresses: MutableList<InetAddress> = ArrayList()
            for (ip in list) {
                val ipStr = ip.split("\\.".toRegex()).toTypedArray()
                val ipBuf = ByteArray(4)
                for (i in 0..3) {
                    ipBuf[i] = (ipStr[i].toInt() and 0xff).toByte()
                }
                addresses.add(InetAddress.getByAddress(hostname, ipBuf))
            }
            return addresses
        }

        fun buildAddress(ip: String, hostname: String): List<InetAddress>? {
            val addresses: MutableList<InetAddress> = ArrayList()
            val ipStr = ip.split("\\.".toRegex()).toTypedArray()
            val ipBuf = ByteArray(4)
            for (i in 0..3) {
                ipBuf[i] = (ipStr[i].toInt() and 0xff).toByte()
            }
            addresses.add(InetAddress.getByAddress(hostname, ipBuf))
            return addresses
        }
    }

}