package com.tn.lib.net.dns.internal

import java.net.InetAddress
import java.util.concurrent.ConcurrentHashMap

/**
 * 默认ip池
 */
object IpPool {

    private val mAddressMap = ConcurrentHashMap<String, List<InetAddress>?>()

    init {
        refreshAddressMap(IpPoolDefaultData.getDefaultAddressData())
    }

    /**
     * 如果没有从开机配置中获取域名和ip映射，取本地默域名与ip
     */
    private fun refreshAddressMap(map: Map<String, List<InetAddress>?>) {
        mAddressMap.clear()
        mAddressMap.putAll(map)
    }

    fun getDomainMap(): ConcurrentHashMap<String, List<InetAddress>?> {
        return mAddressMap
    }

    fun getAddress(host: String): List<InetAddress>? {
        return mAddressMap[host]
    }


}