package com.tn.lib.net.exception

/**
 * 网络请求异常类
 */
class ApiException : Exception {

    /**
     * 错误信息
     */
    var errMsg: String? = null

    /**
     * 错误码
     */
    var errCode: String? = null

    constructor(throwable: Throwable, code: String?) : super(throwable) {
        this.errCode = code
    }

    constructor(throwable: Throwable, code: String?, msg: String?) : super(throwable) {
        this.errCode = code
        this.errMsg = msg
    }


    override fun toString(): String {
        return "ApiException(errMsg='$errMsg', errCode='$errCode')"
    }
}