package com.tn.lib.net.exception

import android.net.ParseException
import android.text.TextUtils
import android.util.MalformedJsonException
import com.blankj.utilcode.util.GsonUtils
import com.google.gson.JsonParseException
import com.tn.lib.net.bean.BaseDto
import org.json.JSONException
import retrofit2.HttpException
import java.net.ConnectException
import java.net.SocketTimeoutException
import java.net.UnknownHostException


class ExceptionEngine {


    companion object {

        //客户端报错
        private val UN_KNOWN_ERROR = 1000 //未知异常

        private val PARAM_ERROR = 110004 //请求参数错误

        private val CONNECT_ERROR = 9003 //网络连接异常

        private val SERVER_ERROR = 1102 //服务器响应异常

        private val DATA_PARSE_ERROR = 11000 //数据解析异常
        private val DATA_DISPOSE_ERROR = 11001 //数据处理异常

        private val UN_KNOWN_SERVER_ERROR = 1032 //服务器未知异常

        private val TIME_OUT_ERROR = 60002


        fun handleException(e: Throwable?): ApiException {
            val ex: ApiException
            return if (e is HttpException) {
                //HTTP错误
                val errorResult = e.response()?.errorBody()?.string()
                val baseDto = GsonUtils.fromJson(errorResult, BaseDto::class.java)
                if (baseDto == null){
                    ApiException(e, e.code().toString(), e.message())
                } else{
                    if (TextUtils.isEmpty(baseDto.msg)) {
                        baseDto.msg = "Oops，something went wrong"
                    }
                    ApiException(e, e.code().toString(), baseDto.msg)
                }
            } else if (e is ServerException) {
                //服务器返回的错误
//                doServerException(e)
                ApiException(e, e.errCode, e.errMsg)
            } else if (e is JsonParseException || e is JSONException || e is ParseException || e is MalformedJsonException) {  //解析数据错误
                ApiException(e, DATA_PARSE_ERROR.toString(), "Oops，something went wrong")
            } else if (e is ConnectException) {
                //连接网络错误
                ApiException(e, CONNECT_ERROR.toString(), "Oops，something went wrong")
            } else if (e is SocketTimeoutException) {
                //网络超时
                ApiException(e, TIME_OUT_ERROR.toString(), "Oops，something went wrong")
            } else if (e is UnknownHostException) {
                //网络异常
                ApiException(e, CONNECT_ERROR.toString(), "Oops，something went wrong")
            } else {  //未知错误
                ApiException(e ?: throw RuntimeException("未知异常"), UN_KNOWN_ERROR.toString(), "Oops，something went wrong")
            }
        }

    }
}