package com.tn.lib.net.interceptor;

import android.text.TextUtils;

import java.io.IOException;
import java.util.List;

import androidx.annotation.NonNull;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

/**
 * @author xinbing.zhang
 * @date :2023/10/17 10:10
 * @description: 处理多 BaseUrl问题
 */
public class BaseUrlInterceptor implements Interceptor {

    /**
     * 多BaseURL处理标识
     */
    public static final String MULTIPLE_BASE_URL_TAG = "multiple_base_url";

    @NonNull
    @Override
    public Response intercept(Chain chain) throws IOException {
        //获取request
        Request request = chain.request();
        //从request中获取原有的HttpUrl实例oldHttpUrl
        HttpUrl oldHttpUrl = request.url();
        //获取request的创建者builder
        Request.Builder builder = request.newBuilder();
        //这种情况适用于 替换请求外部域名 比如获取ps 商单
        //从request中获取headers，判断是否是目标key
        List<String> headerValues = request.headers(MULTIPLE_BASE_URL_TAG);
        // 获取到的不为空，那就是命中了
        if (!headerValues.isEmpty()) {
            //如果有这个header，先将配置的header删除，因此header仅用作app和okhttp之间使用
            builder.removeHeader(MULTIPLE_BASE_URL_TAG);
            //匹配获得新的BaseUrl
            String headerValue = headerValues.get(0);
            HttpUrl newBaseUrl;
            if (!TextUtils.isEmpty(headerValue)) {
                newBaseUrl = HttpUrl.parse(headerValue);
            } else {
                newBaseUrl = oldHttpUrl;
            }
            if (null != newBaseUrl) {
                //重建新的HttpUrl，修改需要修改的url部分
                HttpUrl newFullUrl = oldHttpUrl.newBuilder()
                        //更换网络协议
                        .scheme("https")
                        //更换主机名
                        .host(newBaseUrl.host())
                        //更换端口
                        .port(newBaseUrl.port())
                        //移除第一个参数
                        //.removePathSegment(0)
                        .build();
                //重建这个request，通过builder.url(newFullUrl).build()；
                // 然后返回一个response至此结束修改
                return chain.proceed(builder.url(newFullUrl).build());
            }
        }
        /*//host 更换后及时更换到请求上
        String host = CacheIpPool.INSTANCE.getHost();
        if (!TextUtils.equals(host,oldHttpUrl.host())) {
            String scheme = CacheIpPool.INSTANCE.getScheme();
            HttpUrl newUrl = oldHttpUrl.newBuilder()
                    //更换网络协议
                    .scheme(scheme)
                    //更换主机名
                    .host(host)
                    .build();
            // 然后返回一个response至此结束修改
            return chain.proceed(builder.url(newUrl).build());
        }*/
        return chain.proceed(request);
    }
}

