package com.tn.lib.net.interceptor

import com.tn.lib.logger.Logger
import com.tn.lib.util.networkinfo.NetworkUtil
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response
import okio.IOException

/**
 * 重试
 * 重试次数
 * 重试间隔时间
 * 重试规则：超时，服务端返回错误码，http异常
 * 测试：弱网或者大数据请求
 */
class RetryInterceptor : Interceptor {
    private var countinueFailCount = 0
    private var retryMax = 2
    private var lastFailTime = 0L
    private val TAG = "RetryInterceptor"


    override fun intercept(chain: Interceptor.Chain): Response {
        var request: Request = chain.request()
        var response: Response? = doRequest(chain, request)
        var tryCount = 0
        while (response == null && tryCount < retryMax) {
            if (!NetworkUtil.hasCapabilityAsync()) {
                Logger.d(TAG, "no net")
                break
            }
            tryCount++
            // retry the request
//            if (countinueFailCount > 3) {
//                countinueFailCount = 0
//                var addressItem = switchServer(request.url.host)
//                Logger.d(TAG, "switchServer host ${addressItem?.host}")
//                addressItem?.let {
//                    val newUrl = request.url.newBuilder()
//                        .scheme(it.scheme ?: "https")
//                        .host(it.host ?: "api3.aoneroom.com")
//                        .build()
//                    val newRequest = request.newBuilder().url(newUrl).build()
//                    request = newRequest
//                }
//            }
            response = doRequest(chain, request)
        }
        if (response == null) {
            throw IOException()
        }
        return response
    }

    private fun doRequest(chain: Interceptor.Chain, request: Request): Response? {
        var response: Response? = null
        try {
            response = chain.proceed(request)
        } catch (e: Exception) {
            Logger.d(TAG, "doRequest exception ${e.message}")
//            val currentTimeMillis = System.currentTimeMillis()
//            if (currentTimeMillis - lastFailTime < 1000 * 10) {
//                countinueFailCount++
//            } else {
//                countinueFailCount = 0
//            }
//            lastFailTime = currentTimeMillis
        }
        return response
    }



}