package com.tn.lib.net.utils

import com.alibaba.fastjson.JSON
import com.tn.lib.logger.Logger
import okhttp3.FormBody
import okhttp3.Request
import okio.Buffer

class HttpUtils {

    companion object {
        private const val POST = "post"
        private const val GET = "get"
        fun parsePrams(request: Request): MutableMap<String, String> {
            val map = mutableMapOf<String, String>()
            if (GET.equals(request.method, true)) {
                val query = request.url.query
                val allParams = query?.split("&")
                if (allParams != null && allParams.isNotEmpty()) {
                    allParams.forEach {
                        val childParams = it.split("=")
                        if (childParams.size == 2) {//规则内解析,不符合规则的pass
                            map[childParams[0]] = childParams[1]
                        }
                    }
                }
            } else if (POST.equals(request.method, true)) {
                if (request.body is FormBody) {
                    val formBody = request.body as FormBody
                    for (index in 0 until formBody.size) {
                        map[formBody.encodedName(index)] = formBody.encodedValue(index)
                    }
                } else {
                    Logger.d("TNHttpUtils", "json parse start")
                    val buffer = Buffer()
                    request.body?.writeTo(buffer)
                    val json = JSON.parse(buffer.readByteArray()).toString()
                    val newJson = json.replace("{", "").replace("}", "")
                    val allParams = newJson.split(",")
                    if (allParams.isNotEmpty()) {
                        allParams.forEach {
                            val childParams = it.split(":")
                            if (childParams.size == 2) {//规则内解析,不符合规则的pass
                                val key = childParams[0].replace("\"", "")
                                val value = childParams[1].replace("\"", "")
                                map[key] = value
                            }
                        }
                    }
                    Logger.d("TNHttpUtils", " json=${json}")
                }
            }

            return map
        }

    }

}