package com.tn.lib.net.utils

import android.content.Context
import android.net.ConnectivityManager
import android.net.NetworkInfo
import android.telephony.TelephonyManager

object InetUtil {
    //没有网络连接
    const val NETWORK_OFFLINE = "offline"
    const val NETWORK_NONE = "none"
    //wifi连接
    const val NETWORK_WIFI = "Wifi"
    //手机网络数据连接类型
    const val NETWORK_2G = "2G"
    const val NETWORK_3G = "3G"
    const val NETWORK_4G = "4G"
    const val NETWORK_MOBILE = "mobile"
    var lastNetType = NETWORK_NONE
    /**
     * 获取当前网络连接类型
     */
    fun getNetworkType(context: Context?): String {
        try {
            val connManager = context?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

            //获取当前网络类型，如果为空，返回无网络
            val activeNetInfo = connManager.activeNetworkInfo
            if (activeNetInfo == null) {
                return NETWORK_NONE
            } else if (!activeNetInfo.isAvailable) {
                return NETWORK_OFFLINE
            }

            // 判断是不是连接的是不是wifi
            val wifiInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI)
            if (null != wifiInfo) {
                val state = wifiInfo.state
                if (null != state) if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                    return NETWORK_WIFI
                }
            }

            // 如果不是wifi，则判断当前连接的是运营商的哪种网络2g、3g、4g等
            val networkInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE)
            if (null != networkInfo) {
                val state = networkInfo.state
                val subTypeName = networkInfo.subtypeName
                if (null != state) if (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING) {
                    return when (activeNetInfo.subtype) {
                        TelephonyManager.NETWORK_TYPE_GPRS, TelephonyManager.NETWORK_TYPE_CDMA, TelephonyManager.NETWORK_TYPE_EDGE, TelephonyManager.NETWORK_TYPE_1xRTT, TelephonyManager.NETWORK_TYPE_IDEN -> NETWORK_2G
                        TelephonyManager.NETWORK_TYPE_EVDO_A, TelephonyManager.NETWORK_TYPE_UMTS, TelephonyManager.NETWORK_TYPE_EVDO_0, TelephonyManager.NETWORK_TYPE_HSDPA, TelephonyManager.NETWORK_TYPE_HSUPA, TelephonyManager.NETWORK_TYPE_HSPA, TelephonyManager.NETWORK_TYPE_EVDO_B, TelephonyManager.NETWORK_TYPE_EHRPD, TelephonyManager.NETWORK_TYPE_HSPAP -> NETWORK_3G
                        TelephonyManager.NETWORK_TYPE_LTE -> NETWORK_4G
                        else ->                                 //中国移动 联通 电信 三种3G制式
                            if (subTypeName.equals("TD-SCDMA", ignoreCase = true) ||
                                subTypeName.equals("WCDMA", ignoreCase = true) ||
                                subTypeName.equals("CDMA2000", ignoreCase = true)
                            ) {
                                NETWORK_3G
                            } else {
                                NETWORK_MOBILE
                            }
                    }
                }
            }
            return NETWORK_NONE
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return lastNetType
    }
}