package com.tn.lib.net.utils

import com.tencent.mmkv.MMKV
import com.tn.lib.net.cons.HeaderConst
import com.tn.lib.util.mmkv.MMKVHelper

class MkvHeader {

    companion object {
        var netMmkv: MMKV? = MMKVHelper.getVSHOW()

        fun setInstallChannel(v: String) {
            netMmkv?.putString(HeaderConst.INSTALL_CHANNEL, v)
        }

        fun setShareUid(uid: String) {
            netMmkv?.putString(HeaderConst.INSTALL_SHARE_UID, uid)
        }

        fun getShareUid(): String {
            return netMmkv?.getString(HeaderConst.INSTALL_SHARE_UID, "") ?: ""
        }
        fun getInstallChannel(): String {
            return netMmkv?.getString(HeaderConst.INSTALL_CHANNEL, "") ?: ""
        }

        fun setInstallId(v: String) {
            netMmkv?.putString(HeaderConst.INSTALL_ID, v)
        }

        fun getInstallId(): String {
            return netMmkv?.getString(HeaderConst.INSTALL_ID, "") ?: ""
        }

        fun setToken(token: String) {
            netMmkv?.putString(HeaderConst.USER_TOKEN, token)
        }

        fun getToken(): String {
            return netMmkv?.getString(HeaderConst.USER_TOKEN, "") ?: ""
        }

        fun setUserId(userId: String) {
            netMmkv?.putString(HeaderConst.KV_MY_USERID, userId)
        }

        fun getUserId(): String {
            return netMmkv?.getString(HeaderConst.KV_MY_USERID, "") ?: ""
        }

        fun setScene(scene: String) {
            netMmkv?.putString(HeaderConst.KV_POPLUAR_SCENE_STR, scene)
        }

        fun getScene(): String {
            return netMmkv?.getString(HeaderConst.KV_POPLUAR_SCENE_STR, "transsnet") ?: ""
        }

        fun setAlg(alg: String) {
            netMmkv?.putString(HeaderConst.KV_HEAD_ALG, alg)
        }

        fun getAlg(): String {
            return netMmkv?.getString(HeaderConst.KV_HEAD_ALG, "") ?: ""
        }

        fun setSessionId(sessionId: String) {
            netMmkv?.putString(HeaderConst.SESSION_ID, sessionId)
        }

        fun getSessionId(): String {
            return netMmkv?.getString(HeaderConst.SESSION_ID, "") ?: ""
        }

        fun setAccountType(accountType: String) {
            netMmkv?.putString(HeaderConst.ACCOUNT_TYPE, accountType)
        }

        fun getAccountType(): String {
            return netMmkv?.getString(HeaderConst.ACCOUNT_TYPE, "") ?: ""
        }

        fun setEventId(eventId: String) {
            netMmkv?.putString(HeaderConst.EVENT_ID, eventId)
        }

        fun getEventId(): String {
            return netMmkv?.getString(HeaderConst.EVENT_ID, "") ?: ""
        }

        fun setRecId(recId: String) {
            netMmkv?.putString(HeaderConst.REC_ID, recId)
        }

        fun getRecId(): String {
            return netMmkv?.getString(HeaderConst.REC_ID, "") ?: ""
        }

        fun setClientVersionCode(clientVersionCode: String) {
            netMmkv?.putString(HeaderConst.CLIENT_VERSION_CODE, clientVersionCode)
        }

        fun getClientVersionCode(): String {
            return netMmkv?.getString(HeaderConst.CLIENT_VERSION_CODE, "") ?: ""
        }

        fun setImsi(imsi: String) {
            netMmkv?.putString(HeaderConst.VSKIT_IMSI, imsi)
        }

        fun getImsi(): String {
            return netMmkv?.getString(HeaderConst.VSKIT_IMSI, "99999999999999") ?: ""
        }

        fun setImei(imei: String) {
            netMmkv?.putString(HeaderConst.VSKIT_IMEI, imei)
        }

        fun getImei(): String {
            return netMmkv?.getString(HeaderConst.VSKIT_IMEI, "110") ?: ""
        }


        fun setNetspeed(speed: Int) {
            netMmkv?.putInt(HeaderConst.NET_SPEED, speed)
        }

        fun getNetspeed(): Int {
            return netMmkv?.getInt(HeaderConst.NET_SPEED, 20) ?: 0
        }


        fun setSPCode(spcode:String) {
            netMmkv?.putString(HeaderConst.SP_CODE, spcode)
        }

        fun getSPCode(): String {
            return netMmkv?.getString(HeaderConst.SP_CODE, "") ?: ""
        }


        /**
         * 清除存储的用户信息
         */
        fun clearHeader() {
            setUserId("")
            setToken("")
        }


    }

}