package com.tn.lib.net.annotatioProcess

import com.tn.lib.net.annotation.ApiType
import com.tn.lib.util.md5.MD5

object AnnotationDataManager {

     private val map= mutableMapOf<String,ApiType>()//类型缓存处理

     /**
      * 以url作为每个请求的key，保证不重复
      */
     fun setType(url:String,type:ApiType){
         val key=MD5.MD5Encode(url)
         if(map.containsKey(key)){
             return
         }
         map[key]=type

     }

     fun getType(url:String): ApiType {
          val key=MD5.MD5Encode(url)
          if(!map.containsKey(key)){
              return ApiType.COMMON
          }
          return  map[key]!!
     }

}