//package com.tn.lib.net.cache
//
//import android.text.TextUtils
//import com.alibaba.fastjson.JSON
//import com.alibaba.fastjson.JSONObject
//import com.blankj.utilcode.util.FileUtils
//import com.tencent.mmkv.MMKV
//import com.tn.lib.logger.Logger
//import com.tn.lib.net.Http
//import com.tn.lib.util.md5.MD5
//import com.tn.lib.util.mmkv.MKCons
//import com.tn.lib.util.mmkv.string
//import okhttp3.Cache
//import java.io.File
//import java.util.*
//
//
//class HttpCache {
//    private val TAG = "TNHttpCache"
//
//    private var cache: Cache? = null
//    private val urlMap = Collections.synchronizedMap(HashMap<String, CacheResult>(50))
//    private var netMmkv: MMKV = MMKV.mmkvWithID(MKCons.KV_ID_VSHOW)!!
//    private val kvNetCache by netMmkv.string(KV_NET_CACHE, "")
//
//
//    fun getCache(): Cache {
//        val file = File(CACHE_DIRECTORY)
//        val cacheSize = MAX_CACHE_SIZE
//        if (cache == null) {
//            cache = Cache(file, cacheSize)
//        }
//        return cache!!
//    }
//
//
//    fun put(url: String, value: CacheResult) {
//        val key = MD5.MD5Encode(url)
//        if (urlMap.containsKey(key)) {
//            return
//        }
//        try {
//            urlMap[key] = value
//            val json = JSON.toJSON(urlMap).toString()
//            netMmkv.putString(KV_NET_CACHE, json)
//        } catch (e: Exception) {
//            e.printStackTrace()
//        }
//    }
//
//
//    companion object {
//        private const val KV_NET_CACHE = "kv_net_cache"
//        private const val MAX_CACHE_SIZE = 30 * 1024 * 1024L//10mb
//        private const val MAX_CACHE_COUNT = 2//最大缓存接口数量
//
//        private val CACHE_DIRECTORY =
//            Http.application?.getExternalFilesDir("")?.absolutePath + File.separator + "ok_cache"
//        private var tnHttpCache: HttpCache? = null
//            get() {
//                if (field == null) {
//                    field = HttpCache()
//                }
//                return field
//            }
//
//        @Synchronized
//        fun get(): HttpCache {
//            return tnHttpCache!!
//        }
//    }
//
//
//}