package com.tn.lib.net.dns

import com.tn.lib.net.dns.internal.IpPool
import okhttp3.Dns
import okhttp3.OkHttpClient
import java.net.InetAddress

/**
 * 域名配置实现类
 */
class HttpDnsImpl : HttpDnsService {

    var mDns: Dns

    init {
        val client = OkHttpClient.Builder().build()
        mDns = DohProviders.buildGoogle(client)
    }

    override fun getIpByHostAsync(hostname: String): InetAddress {
        val ips = getIpsByHost(hostname)
        return ips[0]
    }


    override fun getIpsByHostAsync(hostname: String): List<InetAddress>? {
        return getIpsByHost(hostname)
    }

    private fun getIpsByHost(hostname: String): List<InetAddress> {
        return try {
            IpPool.getAddress(hostname) ?: Dns.SYSTEM.lookup(hostname)
        } catch (e: Exception) {
            mDns.lookup(hostname)
        }
    }

}