package com.tn.lib.net.dns

import okhttp3.Dns
import java.net.InetAddress

/**
 * DNS解析配置，涉及到下载和多域名需要再具体测试和改进
 */
class OkHttpDns : Dns {
    private var httpDnsService: HttpDnsService? = null

    init {
        httpDnsService = HttpDns.getService()
    }

    override fun lookup(hostname: String): List<InetAddress> {
        val ip = httpDnsService?.getIpByHostAsync(hostname)
        if (ip != null) {
            return httpDnsService?.getIpsByHostAsync(hostname) ?: Dns.SYSTEM.lookup(hostname)
        }
        return Dns.SYSTEM.lookup(hostname)
    }
}