package com.tn.lib.net.interceptor

import android.os.Handler
import android.os.Looper
import android.text.TextUtils
import com.alibaba.android.arouter.launcher.ARouter
import com.tn.lib.logger.Logger
import com.tn.lib.net.cons.NetConst
import com.tn.lib.net.cons.NetTag
import com.tn.lib.net.dns.or.CacheIpPool
import okhttp3.Interceptor
import okhttp3.Response

class DynamicHostInterceptor : Interceptor {
    companion object {
        private const val TAG = "DynamicHostInterceptor"
        const val PAGE_NOT_AVAILABLE = "/main/page_not_available"
    }

    val handler by lazy { Handler(Looper.getMainLooper()) }

    @Volatile
    var hasStartActivity = false


    override fun intercept(chain: Interceptor.Chain): Response {
        var request = chain.request()
        //域名不可用后替换 && 移除host参数
        val newUrl = request.url.newBuilder()
        if (!TextUtils.equals(request.url.host, CacheIpPool.getHost())
            || !TextUtils.equals(request.url.scheme, CacheIpPool.getScheme())
        ) {
            newUrl.scheme(CacheIpPool.getScheme())
                .host(CacheIpPool.getHost())
                .removeAllQueryParameters(NetConst.HOST)
        } else {
            //移除host参数
            newUrl.removeAllQueryParameters(NetConst.HOST)
        }
        val newRequest = request.newBuilder().url(newUrl.build()).build()
        val response = chain.proceed(newRequest)
        Logger.i(
            NetTag.TAG,
            "DynamicHostInterceptor response ${response.code} : ${newRequest.url} protocol: ${response.protocol} ",
            writeToFile = true)
        return response
    }

}