package com.tn.lib.net.interceptor.header

import com.tn.lib.net.cons.HeaderConst
import okhttp3.Interceptor
import okhttp3.Request
import okhttp3.Response

/**
 * 通用header头封装
 */
class HeaderInterceptor : Interceptor {
    private val TAG = "HeaderInterceptor"

    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val dynamicHeaderRequest = updateHeaders(request)
        var newRequest = generateClientRequest(dynamicHeaderRequest, "")
        return chain.proceed(newRequest)
    }

    private fun updateHeaders(request: Request): Request {
        val headers = HeaderHelper.getHeaders()
        if (headers.isEmpty()) {
            return request
        }
        val builder = request.newBuilder()
        headers.forEach { (key, value) ->
            builder.header(key, value)
        }
        return builder.build()
    }


    private fun generateClientRequest(request: Request, timeStamp: String): Request {
        //在这里是否可以拿到注解上的内容
        val client = HeaderHelper.builderCommonHeaderJson()
        val requestBuilder = request.newBuilder()
        requestBuilder.addHeader(HeaderConst.HEADER_X_VSKIT_CLIENT, client)
        val appBackground = HeaderHelper.appBackground
        requestBuilder.addHeader(HeaderConst.HEADER_X_CLIENT_STATUS, (if (appBackground == true) 0 else 1).toString())
        return requestBuilder.build()
    }


}