package com.tn.lib.net.utils

import com.alibaba.fastjson.JSON
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody
import okhttp3.RequestBody.Companion.toRequestBody

class ParamHelper {

    companion object {

        /**
         * 对象转body
         * json转body
         */
        fun createBody(req: Any): RequestBody? {
            try {
                if (req is String) {
                    return req.toRequestBody("application/json".toMediaTypeOrNull())
                }
                val reqJson = JSON.toJSON(req).toString()
                return reqJson.toRequestBody("application/json".toMediaTypeOrNull())
            } catch (e: Exception) {
                e.printStackTrace()
            }
            return null
        }


    }
}