package com.tn.lib.net.base

import android.util.Log
import com.tn.lib.logger.MBLogger
import com.tn.lib.net.bean.BaseDto
import com.tn.lib.net.exception.ExceptionEngine
import com.tn.lib.net.exception.ServerException
import io.reactivex.rxjava3.core.Observer
import io.reactivex.rxjava3.disposables.Disposable

abstract class BaseObserver<T> : Observer<BaseDto<T>> {
    private val TAG = "TNBaseObserver"

    companion object {
        private val RES_CODE_SUCCESS = "0"
    }

    override fun onSubscribe(d: Disposable) {
        MBLogger.d(TAG, "Disposable=${d.isDisposed}")
    }

    override fun onNext(t: BaseDto<T>) {
        if (t.code == RES_CODE_SUCCESS) {
            MBLogger.d(TAG, "onNext: data=${t.data}")
            onSuccess(t.data)
            onSuccess2(t)
        } else {
            MBLogger.d(TAG, "onNext: Server errorInfo=${t.data}")
            try {
                val ex = ExceptionEngine.handleException(ServerException(t?.code, t?.msg))
//            onFailure(ex.errCode, ex.errMsg)
                onFailure(ex.errCode, t?.msg)
            } catch (e: Exception) {
                Log.e(TAG, "onNext Exception ${e.message}")
            }
        }
    }

    override fun onError(e: Throwable) {
        try {
            val ex = ExceptionEngine.handleException(e)
            MBLogger.d(TAG, "onError: errorInfo=${e}")
            onFailure(ex.errCode, ex.errMsg)
        } catch (e: Exception) {
            Log.e(TAG, "onError Exception ${e.message}")
            onFailure("", e.message)
        }
    }

    override fun onComplete() {
        MBLogger.d(TAG, "onComplete")
    }

    /**
     * 失败回调
     */
    abstract fun onFailure(code: String?, message: String?)

    /**
     * 成功回调
     */
    open fun onSuccess(data: T?) {

    }

    /**
     * 适配上层，参数全部传递，避免lifecycle传参问题
     */
    open fun onSuccess2(baseDto: BaseDto<T>) {

    }

}