package com.tn.lib.net.convert;

import android.text.TextUtils;

import com.blankj.utilcode.util.GsonUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tn.lib.logger.MBLogger;
import com.tn.lib.net.bean.BaseDto;
import com.tn.lib.net.cons.NetConst;
import com.tn.lib.net.cons.NetTag;
import com.tn.lib.net.exception.ServerException;

import java.io.IOException;
import java.lang.reflect.Type;

import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import retrofit2.Converter;

public class FastJsonResponseBodyConverter<T> implements Converter<ResponseBody, T> {
    private final Type type;
    private final String code;
    private Gson gson;

    private final String DEFAULT = "{\"code\":200005,\"data\":{},\"msg\":\"unknown error\"}";

    public FastJsonResponseBodyConverter(Type type, String codeKey) {
        this.type = type;
        this.code = codeKey;
        gson = new Gson();
    }

    /*
     * 转换方法
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        BufferedSource bufferedSource = Okio.buffer(value.source());
        String tempStr = bufferedSource.readUtf8();
        MBLogger.Companion.d(NetTag.TAG, "Converter origin json:" + tempStr, false);
        bufferedSource.close();
        if (TextUtils.equals(code, NetConst.NO_CODE)) {
            return (T) tempStr;
        }
        try {
            return GsonUtils.fromJson(tempStr, type);
        } catch (JsonSyntaxException e) {
            MBLogger.Companion.e(NetTag.TAG, "error =" + e.getMessage() + "json= " + tempStr, true);
            return gson.fromJson(tempStr, type);
        }
//        Logger.Companion.d("Converter origin json:" + tempStr);
//        boolean hasNoCode = TextUtils.equals(code, NetConst.NO_CODE);
//        return generateData(tempStr, bufferedSource, hasNoCode);

    }

    private T generateData(String json, BufferedSource bufferedSource, boolean hasNoCode) {
        try {
            BaseDto<T> baseDto = gson.fromJson(json, BaseDto.class);
            if (TextUtils.equals(baseDto.getCode(), "0")) {
                if (baseDto.getData() == null) {
                    return (T) baseDto.getMsg();
                }
                if (hasNoCode) {
                    return gson.fromJson(json, type);
                } else {
                    return gson.fromJson(gson.toJson(baseDto.getData()), type);
                }

            } else {
                throw new ServerException(baseDto.getCode(), baseDto.getMsg());
            }
        } catch (Throwable t) {
            throw t;
        } finally {
            try {
                bufferedSource.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}