package com.tn.lib.net.dns.internal

import com.tn.lib.net.dns.DnsParse
import java.net.InetAddress

/**
 * 默认pool数据，这里的数据是从服务器获取的，如果后续服务器下发内容有所更新，这里最好随之更新
 */
object IpPoolDefaultData {

    private var mLocalUrlList: List<String>
    private var mLocalUpgradeUrlList: List<String>
    private var mLocalLogUrlList: List<String>
    private var mLocalTestUrlList: List<String>

    private val LOCAL_URLS = arrayOf(
        "api.vskit.tv",
        "opr-activity.vskit.tv",
        "promo.vskit.tv",
        "share.vskit.tv",
        "up6.vskit.tv",
        "vshow.vskit.tv",
        "h5-banner.vskit.tv",
        "s.vskit.tv",
        "thirdparty.vskit.tv",
        "up10.vskit.tv",
        "search.vskit.tv",
        "user.vskit.tv",
        "h5.vskit.tv",
        "media.vskit.tv",
        "policies.vskit.tv",
        "up1.vskit.tv",
        "up9.vskit.tv",
        "device.vskit.tv",
        "up7.vskit.tv",
        "free-api.vskit.tv",
        "up.vskit.tv",
        "up2.vskit.tv",
        "up5.vskit.tv",
        "up8.vskit.tv",
        "free-upload.vskit.tv",
        "medias.vskit.tv",
        "up3.vskit.tv",
        "up4.vskit.tv",
        "video.vskit.tv",
        "ws-api.vskit.tv"
    )

    private val LOCAL_IP = arrayOf(
        "75.2.101.231",
        "99.83.244.82"
    )

    private val LOCAL_UPGRADE_URL = arrayOf(
        "free-upgrade.vskit.tv",
        "upgrade.vskit.tv"
    )

    private val LOCAL_UPGRADE_IP = arrayOf(
        "52.215.245.48"
    )

    private val LOCAL_TEST_URL = arrayOf(
        "api.mylichking.com"
    )

    private val LOCAL_TEST_IP = arrayOf(
        "13.250.82.81"
    )

    private val LOCAL_LOG_URL = arrayOf(
        "vskit-log.vskit.tv"
    )

    private val LOCAL_LOG_IP = arrayOf(
        "99.83.171.79",
        "75.2.11.222"
    )

    init {
        mLocalUrlList = LOCAL_URLS.toList()
        mLocalUpgradeUrlList = LOCAL_UPGRADE_URL.toList()
        mLocalLogUrlList = LOCAL_LOG_URL.toList()
        mLocalTestUrlList = LOCAL_TEST_URL.toList()
    }

    fun getDefaultUrlList(): List<String> {
        val list = ArrayList<String>()
        list.addAll(mLocalUrlList)
        list.addAll(mLocalUpgradeUrlList)
        list.addAll(mLocalLogUrlList)
        list.addAll(mLocalTestUrlList)
        return list
    }

    fun getDefaultAddressData(): Map<String, List<InetAddress>?> {
        val map = HashMap<String, List<InetAddress>?>()
        for (s in mLocalUrlList) {
            map[s] = DnsParse.buildAddress(LOCAL_IP, s)
        }
        for (s in mLocalUpgradeUrlList) {
            map[s] = DnsParse.buildAddress(LOCAL_UPGRADE_IP, s)
        }
        for (s in mLocalLogUrlList) {
            map[s] = DnsParse.buildAddress(LOCAL_LOG_IP, s)
        }
        for (s in mLocalTestUrlList) {
            map[s] = DnsParse.buildAddress(LOCAL_TEST_IP, s)
        }
        return map
    }
}