package com.tn.lib.net.exception

/**
 * 服务器返回的错误码信息
 */
class ServerException : RuntimeException {

    /**
     * 错误码
     */
    var errCode: String? = null

    /**
     * 错误信息
     */
    var errMsg: String? = null


    constructor(errCode: String?, errMsg: String?) : super() {
        this.errCode = errCode
        this.errMsg = errMsg
    }

    override fun toString(): String {
        return "ServerException(errMsg='$errMsg', errCode='$errCode')"
    }
}