package com.tn.lib.net.interceptor.header

import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import com.alibaba.fastjson.JSON
import com.alibaba.fastjson.serializer.SerializerFeature
import com.blankj.utilcode.util.AppUtils
import com.blankj.utilcode.util.Utils
import com.meituan.android.walle.WalleChannelReader
import com.tn.lib.net.Http
import com.tn.lib.net.cons.HeaderConst
import com.tn.lib.net.utils.MkvHeader
import com.tn.lib.util.device.TNDeviceHelper
import com.tn.lib.util.networkinfo.NetworkUtil
import java.util.Locale
import java.util.TimeZone
import java.util.UUID

/**
 * 公共参数辅助类.
 */
class HeaderHelper {

    companion object {

        const val DEFAULT_CHANNEL = "gp"

        /**
         *  冷启唯一
         */
        val sessionId: String = UUID.randomUUID().toString()

        const val PLAT_FORM = "android"
        const val LANE_KEY = "x-md-global-color"


        private val extensionHeaders = mutableMapOf<String, String>()

        var localLanguage: String? = null

        @Volatile
        var appBackground: Boolean? = true

        fun addHeader(key: String, value: String) {
            extensionHeaders[key] = value
        }

        fun getHeaders(): MutableMap<String, String> {
            return extensionHeaders
        }

        fun removeHeader() {
            extensionHeaders.clear()
        }

        init {
            var laneValue = MkvHeader.netMmkv?.getString(HeaderHelper.LANE_KEY, "")
            if (TextUtils.isEmpty(laneValue).not()) {
                extensionHeaders[LANE_KEY] = laneValue.toString()
            }
        }

        /**
         * 构造普通接口通用头部
         */
        fun builderCommonHeaderJson(): String {
            val netConfig = Http.netConfig

            val headMap = linkedMapOf<String, Any>()

            try {
                headMap["package_name"] = AppUtils.getAppPackageName()
                val clientName = netConfig?.versionName
                if (!TextUtils.isEmpty(clientName)) {
                    headMap["version_name"] = clientName ?: ""
                }
                val versionCode = AppUtils.getAppVersionCode()
                if (versionCode > 0) {
                    headMap["version_code"] = versionCode
                }
                headMap["os"] = PLAT_FORM
                headMap["os_version"] = TNDeviceHelper.getOsVersion()

                // 安装渠道
                val channel = MkvHeader.getInstallChannel()
                if (!TextUtils.isEmpty(channel)) {
                    headMap[HeaderConst.INSTALL_CHANNEL] = MkvHeader.getInstallChannel()
                }

                headMap[HeaderConst.DEVICE_ID] = TNDeviceHelper.getDeviceId()
                headMap[HeaderConst.INSTALL_STORE] = getCurrentChannel(Utils.getApp()).toString()


                val gid = TNDeviceHelper.getGaid()
                if (!TextUtils.isEmpty(gid)) {
                    headMap["gaid"] = gid
                }
                var brand = MkvHeader.netMmkv?.getString(HeaderConst.PHONE_BRAND, "") ?: ""
                if (TextUtils.isEmpty(brand)) {
                    brand = TNDeviceHelper.getBrand()
                }
                if (!TextUtils.isEmpty(brand)) {
                    headMap["brand"] = brand
                }
                headMap["model"] = TNDeviceHelper.getModel()
                headMap["system_language"] = localLanguage ?: Locale.getDefault().language
                headMap["net"] = NetworkUtil.getNetworkType()
                headMap["region"] = Locale.getDefault().country
                //headMap["region"] = "NG"
                headMap["timezone"] = TimeZone.getDefault().id
                // headMap["lon"] =
                // headMap["lat"]
                //var spCode = MkvHeader.netMmkv?.getString(HeaderConst.SP_CODE, "") ?: ""
                var spCode = MkvHeader.netMmkv?.getString(HeaderConst.SP_CODE, "") ?: ""
                if (TextUtils.isEmpty(spCode)) {
                    spCode = TNDeviceHelper.getSimOperator()
                }
                headMap["sp_code"] = spCode
                if (extensionHeaders.isNotEmpty()) {
                    headMap.putAll(extensionHeaders)
                }
                try {
                    //headMap["main_board"] = TNDeviceHelper.getHardWare() ?: ""
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                return JSON.toJSONString(headMap)
            } catch (e: Exception) {
                return JSON.toJSONString(headMap, SerializerFeature.BrowserCompatible)
            }
        }

        /**
         * 增加埋点公共参数
         */
        fun addEventCommonParams(bundle: Bundle) {
            bundle.putString(HeaderConst.SESSION_ID, sessionId)
            bundle.putString(HeaderConst.DEVICE_ID, TNDeviceHelper.getDeviceId())
            bundle.putString(HeaderConst.INSTALL_STORE, getCurrentChannel(Utils.getApp()))

            // 安装渠道
            val channel = MkvHeader.getInstallChannel()
            if (!TextUtils.isEmpty(channel)) {
                bundle.putString(HeaderConst.INSTALL_CHANNEL, channel)
            }
            // 安装ID
            val id = MkvHeader.getInstallId()
            if (!TextUtils.isEmpty(id)) {
                bundle.putString(HeaderConst.INSTALL_ID, id)
            }
            //分享人ID
            val shareUid = MkvHeader.getShareUid()
            if (!TextUtils.isEmpty(shareUid)) {
                bundle.putString(HeaderConst.INSTALL_SHARE_UID, shareUid)
            }

            // 当前网络状态
            bundle.putString(HeaderConst.NET_STATE, NetworkUtil.getNetState().toString())
        }


        private var currentChannel: String? = null

        /**
         * 获取当前渠道 注意 不支持并发
         * @param context Context
         * @return String?
         */
        fun getCurrentChannel(context: Context): String? {
            var installStore = MkvHeader.netMmkv?.getString(HeaderConst.INSTALL_STORE, "")
            currentChannel =
                if (TextUtils.isEmpty(installStore)) {
                    if (TextUtils.isEmpty(currentChannel)) {
                        var channel = WalleChannelReader.getChannel(context)
                        currentChannel = if (TextUtils.isEmpty(channel)) DEFAULT_CHANNEL else channel
                    }
                    currentChannel
                } else {
                    installStore
                }
            return currentChannel
        }

        /**
         * 当前是否是GP渠道
         */
        fun isGpChannel(): Boolean {
            val installStore = getCurrentChannel(Utils.getApp())
            return TextUtils.equals(installStore, DEFAULT_CHANNEL)
        }

        fun setChannel(channel:String) {
            MkvHeader.netMmkv?.putString(HeaderConst.INSTALL_STORE,channel)
        }
    }


}