/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.convert;

import android.text.TextUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tn.lib.logger.MBLogger;
import com.tn.lib.net.bean.BaseDto;
import com.tn.lib.net.exception.ServerException;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import retrofit2.Converter;

public class FastJsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Type type;
    private final String code;
    private Gson gson;
    private final String DEFAULT = "{\"code\":200005,\"data\":{},\"msg\":\"unknown error\"}";

    public FastJsonResponseBodyConverter(Type type2, String codeKey) {
        this.type = type2;
        this.code = codeKey;
        this.gson = new Gson();
    }

    public T convert(ResponseBody value) throws IOException {
        BufferedSource bufferedSource = Okio.buffer((Source)value.source());
        String tempStr = bufferedSource.readUtf8();
        MBLogger.Companion.d("HttpTag", "Converter origin json:" + tempStr, false);
        bufferedSource.close();
        if (TextUtils.equals((CharSequence)this.code, (CharSequence)"1311")) {
            return (T)tempStr;
        }
        try {
            return (T)GsonUtils.fromJson((String)tempStr, (Type)this.type);
        }
        catch (JsonSyntaxException e) {
            MBLogger.Companion.e("HttpTag", "error =" + e.getMessage() + "json= " + tempStr, true);
            return (T)this.gson.fromJson(tempStr, this.type);
        }
    }

    private T generateData(String json, BufferedSource bufferedSource, boolean hasNoCode) {
        try {
            BaseDto baseDto = (BaseDto)this.gson.fromJson(json, BaseDto.class);
            if (TextUtils.equals((CharSequence)baseDto.getCode(), (CharSequence)"0")) {
                if (baseDto.getData() == null) {
                    String string = baseDto.getMsg();
                    return (T)string;
                }
                if (hasNoCode) {
                    Object object = this.gson.fromJson(json, this.type);
                    return (T)object;
                }
                Object object = this.gson.fromJson(this.gson.toJson(baseDto.getData()), this.type);
                return (T)object;
            }
            throw new ServerException(baseDto.getCode(), baseDto.getMsg());
        }
        finally {
            try {
                bufferedSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

