/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.dns;

import com.tn.lib.net.dns.DnsOverHttps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class DohProviders {
    public static DnsOverHttps buildGoogle(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://dns.google/dns-query")).bootstrapDnsHosts(DohProviders.getByIp("8.8.4.4"), DohProviders.getByIp("8.8.8.8")).build();
    }

    static DnsOverHttps buildGooglePost(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://dns.google/dns-query")).bootstrapDnsHosts(DohProviders.getByIp("8.8.4.4"), DohProviders.getByIp("8.8.8.8")).post(true).build();
    }

    static DnsOverHttps buildCloudflareIp(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://1.1.1.1/dns-query")).includeIPv6(false).build();
    }

    static DnsOverHttps buildCloudflare(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://1.1.1.1/dns-query")).bootstrapDnsHosts(DohProviders.getByIp("1.1.1.1"), DohProviders.getByIp("1.0.0.1")).includeIPv6(false).build();
    }

    static DnsOverHttps buildCloudflarePost(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://cloudflare-dns.com/dns-query")).bootstrapDnsHosts(DohProviders.getByIp("1.1.1.1"), DohProviders.getByIp("1.0.0.1")).includeIPv6(false).post(true).build();
    }

    static DnsOverHttps buildCleanBrowsing(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://doh.cleanbrowsing.org/doh/family-filter/")).includeIPv6(false).build();
    }

    static DnsOverHttps buildChantra(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://dns.dnsoverhttps.net/dns-query")).includeIPv6(false).build();
    }

    static DnsOverHttps buildCryptoSx(OkHttpClient bootstrapClient) {
        return new DnsOverHttps.Builder().client(bootstrapClient).url(HttpUrl.get((String)"https://doh.crypto.sx/dns-query")).includeIPv6(false).build();
    }

    public static List<DnsOverHttps> providers(OkHttpClient client, boolean http2Only, boolean workingOnly, boolean getOnly) {
        ArrayList<DnsOverHttps> result = new ArrayList<DnsOverHttps>();
        result.add(DohProviders.buildGoogle(client));
        if (!getOnly) {
            result.add(DohProviders.buildGooglePost(client));
        }
        result.add(DohProviders.buildCloudflare(client));
        result.add(DohProviders.buildCloudflareIp(client));
        if (!getOnly) {
            result.add(DohProviders.buildCloudflarePost(client));
        }
        if (!workingOnly) {
            result.add(DohProviders.buildCryptoSx(client));
        }
        result.add(DohProviders.buildChantra(client));
        return result;
    }

    private static InetAddress getByIp(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

