/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.dns;

import com.tn.lib.net.dns.DnsOverHttps;
import com.tn.lib.net.dns.DohProviders;
import com.tn.lib.net.dns.HttpDnsService;
import com.tn.lib.net.dns.internal.IpPool;
import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/net/dns/HttpDnsImpl;", "Lcom/tn/lib/net/dns/HttpDnsService;", "<init>", "()V", "mDns", "Lokhttp3/Dns;", "getMDns", "()Lokhttp3/Dns;", "setMDns", "(Lokhttp3/Dns;)V", "getIpByHostAsync", "Ljava/net/InetAddress;", "hostname", "", "getIpsByHostAsync", "", "getIpsByHost", "lib_release"})
public final class HttpDnsImpl
implements HttpDnsService {
    @NotNull
    private Dns mDns;

    public HttpDnsImpl() {
        OkHttpClient client = new OkHttpClient.Builder().build();
        DnsOverHttps dnsOverHttps = DohProviders.buildGoogle(client);
        Intrinsics.checkNotNullExpressionValue((Object)dnsOverHttps, (String)"buildGoogle(...)");
        this.mDns = dnsOverHttps;
    }

    @NotNull
    public final Dns getMDns() {
        return this.mDns;
    }

    public final void setMDns(@NotNull Dns dns) {
        Intrinsics.checkNotNullParameter((Object)dns, (String)"<set-?>");
        this.mDns = dns;
    }

    @Override
    @NotNull
    public InetAddress getIpByHostAsync(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        List<InetAddress> ips = this.getIpsByHost(hostname);
        return ips.get(0);
    }

    @Override
    @Nullable
    public List<InetAddress> getIpsByHostAsync(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return this.getIpsByHost(hostname);
    }

    private final List<InetAddress> getIpsByHost(String hostname) {
        List list;
        try {
            List list2 = IpPool.INSTANCE.getAddress(hostname);
            if (list2 == null) {
                list2 = Dns.SYSTEM.lookup(hostname);
            }
            list = list2;
        }
        catch (Exception e) {
            list = this.mDns.lookup(hostname);
        }
        return list;
    }
}

