/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.dns.internal;

import com.tn.lib.net.dns.internal.IpPoolDefaultData;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\fH\u0002J\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0005J\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/tn/lib/net/dns/internal/IpPool;", "", "<init>", "()V", "mAddressMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Ljava/net/InetAddress;", "refreshAddressMap", "", "map", "", "getDomainMap", "getAddress", "host", "lib_release"})
public final class IpPool {
    @NotNull
    public static final IpPool INSTANCE = new IpPool();
    @NotNull
    private static final ConcurrentHashMap<String, List<InetAddress>> mAddressMap = new ConcurrentHashMap();

    private IpPool() {
    }

    private final void refreshAddressMap(Map<String, ? extends List<? extends InetAddress>> map) {
        mAddressMap.clear();
        mAddressMap.putAll(map);
    }

    @NotNull
    public final ConcurrentHashMap<String, List<InetAddress>> getDomainMap() {
        return mAddressMap;
    }

    @Nullable
    public final List<InetAddress> getAddress(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return mAddressMap.get(host);
    }

    static {
        INSTANCE.refreshAddressMap(IpPoolDefaultData.INSTANCE.getDefaultAddressData());
    }
}

