/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.dns.internal;

import com.tn.lib.net.dns.DnsParse;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00050\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/tn/lib/net/dns/internal/IpPoolDefaultData;", "", "<init>", "()V", "mLocalUrlList", "", "", "mLocalUpgradeUrlList", "mLocalLogUrlList", "mLocalTestUrlList", "LOCAL_URLS", "", "[Ljava/lang/String;", "LOCAL_IP", "LOCAL_UPGRADE_URL", "LOCAL_UPGRADE_IP", "LOCAL_TEST_URL", "LOCAL_TEST_IP", "LOCAL_LOG_URL", "LOCAL_LOG_IP", "getDefaultUrlList", "getDefaultAddressData", "", "Ljava/net/InetAddress;", "lib_release"})
public final class IpPoolDefaultData {
    @NotNull
    public static final IpPoolDefaultData INSTANCE = new IpPoolDefaultData();
    @NotNull
    private static List<String> mLocalUrlList;
    @NotNull
    private static List<String> mLocalUpgradeUrlList;
    @NotNull
    private static List<String> mLocalLogUrlList;
    @NotNull
    private static List<String> mLocalTestUrlList;
    @NotNull
    private static final String[] LOCAL_URLS;
    @NotNull
    private static final String[] LOCAL_IP;
    @NotNull
    private static final String[] LOCAL_UPGRADE_URL;
    @NotNull
    private static final String[] LOCAL_UPGRADE_IP;
    @NotNull
    private static final String[] LOCAL_TEST_URL;
    @NotNull
    private static final String[] LOCAL_TEST_IP;
    @NotNull
    private static final String[] LOCAL_LOG_URL;
    @NotNull
    private static final String[] LOCAL_LOG_IP;

    private IpPoolDefaultData() {
    }

    @NotNull
    public final List<String> getDefaultUrlList() {
        ArrayList list = new ArrayList();
        list.addAll(mLocalUrlList);
        list.addAll(mLocalUpgradeUrlList);
        list.addAll(mLocalLogUrlList);
        list.addAll(mLocalTestUrlList);
        return list;
    }

    @NotNull
    public final Map<String, List<InetAddress>> getDefaultAddressData() {
        HashMap map = new HashMap();
        for (String s : mLocalUrlList) {
            ((Map)map).put(s, DnsParse.Companion.buildAddress(LOCAL_IP, s));
        }
        for (String s : mLocalUpgradeUrlList) {
            ((Map)map).put(s, DnsParse.Companion.buildAddress(LOCAL_UPGRADE_IP, s));
        }
        for (String s : mLocalLogUrlList) {
            ((Map)map).put(s, DnsParse.Companion.buildAddress(LOCAL_LOG_IP, s));
        }
        for (String s : mLocalTestUrlList) {
            ((Map)map).put(s, DnsParse.Companion.buildAddress(LOCAL_TEST_IP, s));
        }
        return map;
    }

    static {
        String[] stringArray = new String[]{"api.vskit.tv", "opr-activity.vskit.tv", "promo.vskit.tv", "share.vskit.tv", "up6.vskit.tv", "vshow.vskit.tv", "h5-banner.vskit.tv", "s.vskit.tv", "thirdparty.vskit.tv", "up10.vskit.tv", "search.vskit.tv", "user.vskit.tv", "h5.vskit.tv", "media.vskit.tv", "policies.vskit.tv", "up1.vskit.tv", "up9.vskit.tv", "device.vskit.tv", "up7.vskit.tv", "free-api.vskit.tv", "up.vskit.tv", "up2.vskit.tv", "up5.vskit.tv", "up8.vskit.tv", "free-upload.vskit.tv", "medias.vskit.tv", "up3.vskit.tv", "up4.vskit.tv", "video.vskit.tv", "ws-api.vskit.tv"};
        LOCAL_URLS = stringArray;
        stringArray = new String[]{"75.2.101.231", "99.83.244.82"};
        LOCAL_IP = stringArray;
        stringArray = new String[]{"free-upgrade.vskit.tv", "upgrade.vskit.tv"};
        LOCAL_UPGRADE_URL = stringArray;
        stringArray = new String[]{"52.215.245.48"};
        LOCAL_UPGRADE_IP = stringArray;
        stringArray = new String[]{"api.mylichking.com"};
        LOCAL_TEST_URL = stringArray;
        stringArray = new String[]{"13.250.82.81"};
        LOCAL_TEST_IP = stringArray;
        stringArray = new String[]{"vskit-log.vskit.tv"};
        LOCAL_LOG_URL = stringArray;
        stringArray = new String[]{"99.83.171.79", "75.2.11.222"};
        LOCAL_LOG_IP = stringArray;
        mLocalUrlList = ArraysKt.toList((Object[])LOCAL_URLS);
        mLocalUpgradeUrlList = ArraysKt.toList((Object[])LOCAL_UPGRADE_URL);
        mLocalLogUrlList = ArraysKt.toList((Object[])LOCAL_LOG_URL);
        mLocalTestUrlList = ArraysKt.toList((Object[])LOCAL_TEST_URL);
    }
}

