/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.dns.or;

import android.text.TextUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.google.gson.reflect.TypeToken;
import com.tencent.mmkv.MMKV;
import com.tn.lib.net.Http;
import com.tn.lib.net.NetMMKVUtils;
import com.tn.lib.net.dns.or.AddressItem;
import com.tn.lib.net.utils.MkvHeader;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Dns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010\nJ\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020\nJ\u0006\u0010-\u001a\u00020\nJ\u0006\u0010.\u001a\u00020\nJ\u0006\u0010/\u001a\u00020\nJ\u000e\u00100\u001a\u00020&2\u0006\u0010,\u001a\u00020\nJ\u000e\u00101\u001a\u00020&2\u0006\u0010,\u001a\u00020\nR\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0018\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0014\u001a\u0004\b#\u0010\u0012\u00a8\u00062"}, d2={"Lcom/tn/lib/net/dns/or/CacheIpPool;", "", "<init>", "()V", "mHostList", "Ljava/util/ArrayList;", "Lcom/tn/lib/net/dns/or/AddressItem;", "Lkotlin/collections/ArrayList;", "mAddressMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "mCurrentBaseUrl", "mHost", "mDevHost", "mScheme", "KEY_IP_LIST", "defaultRelease", "getDefaultRelease", "()Ljava/lang/String;", "defaultRelease$delegate", "Lkotlin/Lazy;", "defaultTest", "getDefaultTest", "defaultTest$delegate", "DEFAULT_ONLINE", "H3_ONLINE_v4", "H3_ONLINE_v4sg", "H3_ONLINE_v5", "H3_ONLINE_v6", "H3_ONLINE_v7", "H3_ONLINE_v8", "H3_ONLINE_v6sg", "H3_ONLINE_in", "DEFAULT_DEDUG", "defaultBaseUrl", "getDefaultBaseUrl", "defaultBaseUrl$delegate", "getCacheUrlList", "", "saveConfig", "json", "getIpAddress", "", "Ljava/net/InetAddress;", "host", "getBaseUrl", "getHost", "getScheme", "setHost", "setDevHost", "lib_release"})
@SourceDebugExtension(value={"SMAP\nCacheIpPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheIpPool.kt\ncom/tn/lib/net/dns/or/CacheIpPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1869#2,2:172\n*S KotlinDebug\n*F\n+ 1 CacheIpPool.kt\ncom/tn/lib/net/dns/or/CacheIpPool\n*L\n101#1:172,2\n*E\n"})
public final class CacheIpPool {
    @NotNull
    public static final CacheIpPool INSTANCE = new CacheIpPool();
    @Nullable
    private static ArrayList<AddressItem> mHostList;
    @NotNull
    private static final ConcurrentHashMap<String, AddressItem> mAddressMap;
    @NotNull
    private static volatile String mCurrentBaseUrl;
    @NotNull
    private static volatile String mHost;
    @NotNull
    private static volatile String mDevHost;
    @NotNull
    private static volatile String mScheme;
    @NotNull
    private static final String KEY_IP_LIST = "key_ip_list";
    @NotNull
    private static final Lazy defaultRelease$delegate;
    @NotNull
    private static final Lazy defaultTest$delegate;
    @NotNull
    public static final String DEFAULT_ONLINE = "api3.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v4 = "api4.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v4sg = "api4sg.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v5 = "api5.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v6 = "api6.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v7 = " api7.aoneroom.com ";
    @NotNull
    public static final String H3_ONLINE_v8 = " api8.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_v6sg = "api6sg.aoneroom.com";
    @NotNull
    public static final String H3_ONLINE_in = "api.inmoviebox.com";
    @NotNull
    public static final String DEFAULT_DEDUG = "test-mse-api.aoneroom.com";
    @NotNull
    private static final Lazy defaultBaseUrl$delegate;

    private CacheIpPool() {
    }

    private final String getDefaultRelease() {
        Lazy lazy = defaultRelease$delegate;
        return (String)lazy.getValue();
    }

    private final String getDefaultTest() {
        Lazy lazy = defaultTest$delegate;
        return (String)lazy.getValue();
    }

    private final String getDefaultBaseUrl() {
        Lazy lazy = defaultBaseUrl$delegate;
        return (String)lazy.getValue();
    }

    public final void getCacheUrlList() {
        try {
            Object object;
            Type type2 = new TypeToken<ArrayList<AddressItem>>(){}.getType();
            mHostList = (ArrayList)GsonUtils.fromJson((String)NetMMKVUtils.INSTANCE.getString(KEY_IP_LIST, Http.Companion.isDev() ? this.getDefaultTest() : this.getDefaultRelease()), (Type)type2);
            ArrayList<AddressItem> arrayList = mHostList;
            if (arrayList != null) {
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AddressItem item = (AddressItem)element$iv;
                    boolean bl = false;
                    String string = item.getHost();
                    boolean bl2 = string != null ? ((CharSequence)string).length() > 0 : false;
                    if (!bl2) continue;
                    item.setIpEnable(true);
                    ((Map)mAddressMap).put(item.getHost(), item);
                }
            }
            ArrayList<AddressItem> arrayList2 = mHostList;
            boolean bl = arrayList2 != null ? !((Collection)arrayList2).isEmpty() : false;
            if (bl) {
                ArrayList<AddressItem> arrayList3 = mHostList;
                mScheme = String.valueOf(arrayList3 != null && (arrayList3 = arrayList3.get(0)) != null ? ((AddressItem)((Object)arrayList3)).getScheme() : null);
                ArrayList<AddressItem> arrayList4 = mHostList;
                mHost = String.valueOf(arrayList4 != null && (arrayList4 = arrayList4.get(0)) != null ? ((AddressItem)((Object)arrayList4)).getHost() : null);
                object = mScheme + "://" + mHost;
            } else {
                object = mCurrentBaseUrl;
            }
            mCurrentBaseUrl = object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void saveConfig(@Nullable String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            NetMMKVUtils.INSTANCE.putString(KEY_IP_LIST, String.valueOf(json));
        }
        this.getCacheUrlList();
    }

    @NotNull
    public final List<InetAddress> getIpAddress(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Dns.SYSTEM.lookup(host);
    }

    @NotNull
    public final String getBaseUrl() {
        if (TextUtils.isEmpty((CharSequence)mCurrentBaseUrl)) {
            mCurrentBaseUrl = this.getDefaultBaseUrl();
        }
        return mCurrentBaseUrl;
    }

    @NotNull
    public final String getHost() {
        String mockHost;
        MMKV mMKV = MkvHeader.Companion.getNetMmkv();
        String string = mockHost = mMKV != null ? mMKV.getString("mock_host_key", "") : null;
        if (!TextUtils.isEmpty((CharSequence)mockHost)) {
            mHost = String.valueOf(mockHost);
        }
        return mHost;
    }

    @NotNull
    public final String getScheme() {
        return mScheme;
    }

    public final void setHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        mHost = host;
    }

    public final void setDevHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        mDevHost = host;
    }

    private static final String defaultRelease_delegate$lambda$0() {
        return "[\n{\n\"host\": \"" + mHost + "\",\n\"ip\": \"\",\n\"scheme\": \"https\"\n}\n]";
    }

    private static final String defaultTest_delegate$lambda$1() {
        return "[{\n    \"host\": \"" + mDevHost + "\",\n    \"ip\": \"8.219.92.106\",\n    \"scheme\": \"https\"\n}]";
    }

    private static final String defaultBaseUrl_delegate$lambda$2() {
        return Http.Companion.isDev() ? "https://" + mDevHost : "https://" + mHost;
    }

    static {
        mAddressMap = new ConcurrentHashMap();
        mCurrentBaseUrl = "";
        mHost = H3_ONLINE_v6;
        mDevHost = DEFAULT_DEDUG;
        mScheme = "https";
        defaultRelease$delegate = LazyKt.lazy(CacheIpPool::defaultRelease_delegate$lambda$0);
        defaultTest$delegate = LazyKt.lazy(CacheIpPool::defaultTest_delegate$lambda$1);
        defaultBaseUrl$delegate = LazyKt.lazy(CacheIpPool::defaultBaseUrl_delegate$lambda$2);
    }
}

