/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.exception;

import android.net.ParseException;
import android.text.TextUtils;
import android.util.MalformedJsonException;
import com.blankj.utilcode.util.GsonUtils;
import com.google.gson.JsonParseException;
import com.tn.lib.net.bean.BaseDto;
import com.tn.lib.net.exception.ApiException;
import com.tn.lib.net.exception.ServerException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/tn/lib/net/exception/ExceptionEngine;", "", "<init>", "()V", "Companion", "lib_release"})
public final class ExceptionEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int UN_KNOWN_ERROR = 1000;
    private static final int PARAM_ERROR = 110004;
    private static final int CONNECT_ERROR = 9003;
    private static final int SERVER_ERROR = 1102;
    private static final int DATA_PARSE_ERROR = 11000;
    private static final int DATA_DISPOSE_ERROR = 11001;
    private static final int UN_KNOWN_SERVER_ERROR = 1032;
    private static final int TIME_OUT_ERROR = 60002;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tn/lib/net/exception/ExceptionEngine$Companion;", "", "<init>", "()V", "UN_KNOWN_ERROR", "", "PARAM_ERROR", "CONNECT_ERROR", "SERVER_ERROR", "DATA_PARSE_ERROR", "DATA_DISPOSE_ERROR", "UN_KNOWN_SERVER_ERROR", "TIME_OUT_ERROR", "handleException", "Lcom/tn/lib/net/exception/ApiException;", "e", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ApiException handleException(@Nullable Throwable e) {
            ApiException apiException;
            Object ex = null;
            if (e instanceof HttpException) {
                Response response = ((HttpException)e).response();
                String errorResult = response != null && (response = response.errorBody()) != null ? response.string() : null;
                BaseDto baseDto = (BaseDto)GsonUtils.fromJson((String)errorResult, BaseDto.class);
                if (baseDto == null) {
                    apiException = new ApiException(e, String.valueOf(((HttpException)e).code()), ((HttpException)e).message());
                } else {
                    if (TextUtils.isEmpty((CharSequence)baseDto.getMsg())) {
                        baseDto.setMsg("Oops\uff0csomething went wrong");
                    }
                    apiException = new ApiException(e, String.valueOf(((HttpException)e).code()), baseDto.getMsg());
                }
            } else if (e instanceof ServerException) {
                apiException = new ApiException(e, ((ServerException)e).getErrCode(), ((ServerException)e).getErrMsg());
            } else if (e instanceof JsonParseException || e instanceof JSONException || e instanceof ParseException || e instanceof MalformedJsonException) {
                apiException = new ApiException(e, String.valueOf(DATA_PARSE_ERROR), "Oops\uff0csomething went wrong");
            } else if (e instanceof ConnectException) {
                apiException = new ApiException(e, String.valueOf(CONNECT_ERROR), "Oops\uff0csomething went wrong");
            } else if (e instanceof SocketTimeoutException) {
                apiException = new ApiException(e, String.valueOf(TIME_OUT_ERROR), "Oops\uff0csomething went wrong");
            } else if (e instanceof UnknownHostException) {
                apiException = new ApiException(e, String.valueOf(CONNECT_ERROR), "Oops\uff0csomething went wrong");
            } else {
                Throwable throwable = e;
                if (throwable == null) {
                    throw new RuntimeException("\u672a\u77e5\u5f02\u5e38");
                }
                apiException = new ApiException(throwable, String.valueOf(UN_KNOWN_ERROR), "Oops\uff0csomething went wrong");
            }
            return apiException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

