/*
 * Decompiled with CFR 0.152.
 */
package com.tn.lib.net.interceptor;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class BaseUrlInterceptor
implements Interceptor {
    public static final String MULTIPLE_BASE_URL_TAG = "multiple_base_url";

    @NonNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl oldHttpUrl = request.url();
        Request.Builder builder = request.newBuilder();
        List headerValues = request.headers(MULTIPLE_BASE_URL_TAG);
        if (!headerValues.isEmpty()) {
            builder.removeHeader(MULTIPLE_BASE_URL_TAG);
            String headerValue = (String)headerValues.get(0);
            HttpUrl newBaseUrl = !TextUtils.isEmpty((CharSequence)headerValue) ? HttpUrl.parse((String)headerValue) : oldHttpUrl;
            if (null != newBaseUrl) {
                HttpUrl newFullUrl = oldHttpUrl.newBuilder().scheme("https").host(newBaseUrl.host()).port(newBaseUrl.port()).build();
                return chain.proceed(builder.url(newFullUrl).build());
            }
        }
        return chain.proceed(request);
    }
}

